<?php

use Illuminate\Database\Migrations\Migration;
use Modules\Accounting\Entities\AccountDetailType;

class PopulateAccountDetailTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $timestamp = date('Y-m-d H:i:s');
        
        $account_detail_types = [
            0 => [
                'id' => '1',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Allowance for bad debts',
                'active' => '1',
                'description' => 'Use Allowance for bad debts to estimate the part of Accounts Receivable that you think you might not collect. Use this only if you are keeping your books on the accrual basis.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            1 => [
                'id' => '2',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Assets available for sale',
                'active' => '1',
                'description' => 'Use Assets available for sale to track assets that are available for sale that are not expected to be held for a long period of time.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            2 => [
                'id' => '3',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Development costs',
                'active' => '1',
                'description' => 'Use Development costs to track amounts you deposit or set aside to arrange for financing, such as an SBA loan, or for deposits in anticipation of the purchase of property or other assets. When the deposit is refunded, or the purchase takes place, remove the amount from this account.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            3 => [
                'id' => '4',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Employee cash advances',
                'active' => '1',
                'description' => 'Use Employee cash advances to track employee wages and salary you issue to an employee early, or other non-salary money given to employees. If you make a loan to an employee, use the Current asset account type called Loans to others, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            4 => [
                'id' => '5',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Inventory',
                'active' => '1',
                'description' => 'Use Inventory to track the cost of goods your business purchases for resale. When the goods are sold, assign the sale to a Cost of sales account.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            5 => [
                'id' => '6',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Investments - Other',
                'active' => '1',
                'description' => 'Use Investments - Other to track the value of investments not covered by other investment account types. Examples include publicly-traded shares, coins, or gold.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            6 => [
                'id' => '7',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Loans to officers',
                'active' => '1',
                'description' => 'If you operate your business as a Corporation, use Loans to officers to track money loaned to officers of your business.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            7 => [
                'id' => '8',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Loans to others',
                'active' => '1',
                'description' => 'Use Loans to others to track money your business loans to other people or businesses. This type of account is also referred to as Notes Receivable. For early salary payments to employees, use Employee cash advances, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            8 => [
                'id' => '9',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Loans to Shareholders',
                'active' => '1',
                'description' => 'If you operate your business as a Corporation, use Loans to Shareholders to track money your business loans to its shareholders',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            9 => [
                'id' => '10',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Other current assets',
                'active' => '1',
                'description' => 'Use Other current assets for current assets not covered by the other types. Current assets are likely to be converted to cash or used up in a year.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            10 => [
                'id' => '11',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Prepaid expenses',
                'active' => '1',
                'description' => 'Use Prepaid expenses to track payments for expenses that you won\'t recognise until your next accounting period. When you recognise the expense, make a journal entry to transfer money from this account to the expense account.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            11 => [
                'id' => '12',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Retainage',
                'active' => '1',
                'description' => 'Use Retainage if your customers regularly hold back a portion of a contract amount until you have completed a project. This type of account is often used in the construction industry, and only if you record income on an accrual basis.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            12 => [
                'id' => '13',
                'business_id' => '0',
                'account_subtype_id' => '1',
                'name' => 'Undeposited funds',
                'active' => '1',
                'description' => 'Use Undeposited funds for cash or cheques from sales that haven\'t been deposited yet. For petty cash, use Cash on hand, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            13 => [
                'id' => '14',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Accumulated amortisation of non-current assets',
                'active' => '1',
                'description' => 'Use Accumulated amortisation of non-current assets to track how much you\'ve amortised an asset whose type is Non-Current Asset.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            14 => [
                'id' => '15',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Assets held for sale',
                'active' => '1',
                'description' => 'Use Assets held for sale to track assets of a company that are available for sale that are not expected to be held for a long period of time.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            15 => [
                'id' => '16',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Deferred tax',
                'active' => '1',
                'description' => 'Use Deferred tax for tax liabilities or assets that are to be used in future accounting periods.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            16 => [
                'id' => '17',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Goodwill',
                'active' => '1',
                'description' => 'Use Goodwill only if you have acquired another company. It represents the intangible assets of the acquired company which gave it an advantage, such as favourable government relations, business name, outstanding credit ratings, location, superior management, customer lists, product quality, or good labour relations.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            17 => [
                'id' => '18',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Intangible assets',
                'active' => '1',
                'description' => 'Use Intangible assets to track intangible assets that you plan to amortise. Examples include franchises, customer lists, copyrights, and patents.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            18 => [
                'id' => '19',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Lease buyout',
                'active' => '1',
                'description' => 'Use Lease buyout to track lease payments to be applied toward the purchase of a leased asset. You don\'t track the leased asset itself until you purchase it.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            19 => [
                'id' => '20',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Licences',
                'active' => '1',
                'description' => 'Use Licences to track non-professional licences for permission to engage in an activity, like selling alcohol or radio broadcasting. For fees associated with professional licences granted to individuals, use a Legal and professional fees expense account, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            20 => [
                'id' => '21',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Long-term investments',
                'active' => '1',
                'description' => 'Use Long-term investments to track investments that have a maturity date of longer than one year.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            21 => [
                'id' => '22',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Organisational costs',
                'active' => '1',
                'description' => 'Use Organisational costs to track costs incurred when forming a partnership or corporation. The costs include the legal and accounting costs necessary to organise the company, facilitate the filings of the legal documents, and other paperwork.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            22 => [
                'id' => '23',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Other non-current assets',
                'active' => '1',
                'description' => 'Use Other non-current assets to track assets not covered by other types. Non-current assets are long-term assets that are expected to provide value for more than one year.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            23 => [
                'id' => '24',
                'business_id' => '0',
'account_subtype_id' => '2', 
                'name' => 'Security deposits',
                'active' => '1',
                'description' => 'Use Security deposits to track funds you\'ve paid to cover any potential costs incurred by damage, loss, or theft. The funds should be returned to you at the end of the contract. If you accept down payments, advance payments, security deposits, or other kinds of deposits, use an Other Current liabilities account with the detail type Other Current liabilities.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            24 => [
                'id' => '25',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Accumulated depletion',
                'active' => '1',
                'description' => 'Use Accumulated depletion to track how much you deplete a natural resource.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            25 => [
                'id' => '26',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Accumulated depreciation on property, plant and equipment',
                'active' => '1',
                'description' => 'Use Accumulated depreciation on property, plant and equipment to track how much you depreciate a fixed asset (a physical asset you do not expect to convert to cash during one year of normal operations).',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            26 => [
                'id' => '27',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Buildings',
                'active' => '1',
                'description' => 'Use Buildings to track the cost of structures you own and use for your business. If you have a business in your home, consult your accountant. Use a Land account for the land portion of any real property you own, splitting the cost of the property between land and building in a logical method. A common method is to mimic the land-to-building ratio on the property tax statement.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            27 => [
                'id' => '28',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Depletable assets',
                'active' => '1',
                'description' => 'Use Depletable assets to track natural resources, such as timberlands, oil wells, and mineral deposits.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            28 => [
                'id' => '29',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Furniture and fixtures',
                'active' => '1',
                'description' => 'Use Furniture and fixtures to track any furniture and fixtures your business owns and uses, like a dental chair or sales booth.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            29 => [
                'id' => '30',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Land',
                'active' => '1',
                'description' => 'Use Land to track assets that are not easily convertible to cash or not expected to become cash within the next year. For example, leasehold improvements.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            30 => [
                'id' => '31',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Leasehold improvements',
                'active' => '1',
                'description' => 'Use Leasehold improvements to track improvements to a leased asset that increases the asset\'s value. For example, if you carpet a leased office space and are not reimbursed, that\'s a leasehold improvement.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            31 => [
                'id' => '32',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Machinery and equipment',
                'active' => '1',
                'description' => 'Use Machinery and equipment to track computer hardware, as well as any other non-furniture fixtures or devices owned and used for your business. This includes equipment that you ride, like tractors and lawn mowers. Cars and lorries, however, should be tracked with Vehicle accounts, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            32 => [
                'id' => '33',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Other fixed asset',
                'active' => '1',
                'description' => 'Use Other fixed asset for fixed assets that are not covered by other asset types. Fixed assets are physical property that you use in your business and that you do not expect to convert to cash or be used up during one year of normal operations.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            33 => [
                'id' => '34',
                'business_id' => '0',
'account_subtype_id' => '3', 
                'name' => 'Vehicles',
                'active' => '1',
                'description' => 'Use Vehicles to track the value of vehicles your business owns and uses for business. This includes off-road vehicles, air planes, helicopters, and boats. If you use a vehicle for both business and personal use, consult your accountant to see how you should track its value.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            34 => [
                'id' => '35',
                'business_id' => '0',
'account_subtype_id' => '4', 
                'name' => 'Accounts Receivable(A/R)',
                'active' => '1',
                'description' => 'Accounts receivable (also called A/R, Debtors, or Trade and other receivables) tracks money that customers owe you for products or services, and payments customers make. Ultimate Pos -Accounting Module  automatically creates one Accounts receivable account for you. Most businesses need only one. Each customer has a register, which functions like an Accounts receivable account for each customer.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            35 => [
                'id' => '36',
                'business_id' => '0',
'account_subtype_id' => '5', 
                'name' => 'Bank',
                'active' => '1',
                'description' => 'Use Bank accounts to track all your current activity, including debit card transactions. Each current account your company has at a bank or other financial institution should have its own Bank type account in Ultimate POS.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            36 => [
                'id' => '37',
                'business_id' => '0',
'account_subtype_id' => '5', 
                'name' => 'Cash and Cash Equivalents',
                'active' => '1',
                'description' => 'Use Cash and Cash Equivalents to track cash or assets that can be converted into cash immediately. For example, marketable securities and Treasury bills.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            37 => [
                'id' => '38',
                'business_id' => '0',
'account_subtype_id' => '5', 
                'name' => 'Cash on hand',
                'active' => '1',
                'description' => 'Use a Cash on hand account to track cash your company keeps for occasional expenses, also called petty cash. To track cash from sales that have not been deposited yet, use a pre-created account called Undeposited funds, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            38 => [
                'id' => '39',
                'business_id' => '0',
'account_subtype_id' => '5', 
                'name' => 'Client trust accounts',
                'active' => '1',
                'description' => 'Use Client trust accounts for money held by you for the benefit of someone else. For example, trust accounts are often used by attorneys to keep track of expense money their customers have given them. Often, to keep the amount in a trust account from looking like it\'s yours, the amount is offset in a "contra" liability account (a Current Liability).',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            39 => [
                'id' => '40',
                'business_id' => '0',
'account_subtype_id' => '5', 
                'name' => 'Money market',
                'active' => '1',
                'description' => 'Use Money market to track amounts in money market accounts. For investments, see Current Assets, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            40 => [
                'id' => '41',
                'business_id' => '0',
'account_subtype_id' => '5', 
                'name' => 'Rents held in trust',
                'active' => '1',
                'description' => 'Use Rents held in trust to track deposits and rent held on behalf of the property owners. Typically only property managers use this type of account.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            41 => [
                'id' => '42',
                'business_id' => '0',
'account_subtype_id' => '5', 
                'name' => 'Savings',
                'active' => '1',
                'description' => 'Use Savings accounts to track your savings and CD activity. Each savings account your company has at a bank or other financial institution should have its own Savings type account. For investments, see Current Assets, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            42 => [
                'id' => '43',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Accrued Liabilities',
                'active' => '1',
                'description' => 'Use Accrued Liabilities to track expenses that a business has incurred but has not yet paid. For example, pensions for companies that contribute to a pension fund for their employees for their retirement.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            43 => [
                'id' => '44',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Client Trust accounts - liabilities',
                'active' => '1',
                'description' => 'Use Client Trust accounts - liabilities to offset Client Trust accounts in assets. Amounts in these accounts are held by your business on behalf of others. They do not belong to your business, so should not appear to be yours on your balance sheet. This "contra" account takes care of that, as long as the two balances match.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            44 => [
                'id' => '45',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Current tax liability',
                'active' => '1',
                'description' => 'Use Current tax liability to track the total amount of taxes collected but not yet paid to the government.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            45 => [
                'id' => '46',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Current portion of obligations under finance leases',
                'active' => '1',
                'description' => 'Use Current portion of obligations under finance leases to track the value of lease payments due within the next 12 months.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            46 => [
                'id' => '47',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Dividends payable',
                'active' => '1',
                'description' => 'Use Dividends payable to track dividends that are owed to shareholders but have not yet been paid.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            47 => [
                'id' => '48',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Income tax payable',
                'active' => '1',
                'description' => 'Use Income tax payable to track monies that are due to pay the company\'s income tax liabilties.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            48 => [
                'id' => '49',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Insurance payable',
                'active' => '1',
                'description' => 'Use Insurance payable to keep track of insurance amounts due. This account is most useful for businesses with monthly recurring insurance expenses.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            49 => [
                'id' => '50',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Line of credit',
                'active' => '1',
                'description' => 'Use Line of credit to track the balance due on any lines of credit your business has. Each line of credit your business has should have its own Line of credit account.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            50 => [
                'id' => '51',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Loan payable',
                'active' => '1',
                'description' => 'Use Loan payable to track loans your business owes which are payable within the next twelve months. For longer-term loans, use the Long-term liability called Notes payable, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            51 => [
                'id' => '52',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Other current liabilities',
                'active' => '1',
                'description' => 'Use Other current liabilities to track monies owed by the company and due within one year.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            52 => [
                'id' => '53',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Payroll clearing',
                'active' => '1',
                'description' => 'Use Payroll clearing to keep track of any non-tax amounts that you have deducted from employee paycheques or that you owe as a result of doing payroll. When you forward money to the appropriate suppliers, deduct the amount from the balance of this account. Do not use this account for tax amounts you have withheld or owe from paying employee wages. For those amounts, use the Payroll tax payable account instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            53 => [
                'id' => '54',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Payroll liabilities',
                'active' => '1',
                'description' => 'Use Payroll liabilities to keep track of tax amounts that you owe to government agencies as a result of paying wages. This includes taxes withheld, health care premiums, employment insurance, government pensions, etc. When you forward the money to the government agency, deduct the amount from the balance of this account.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            54 => [
                'id' => '55',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Prepaid expenses payable',
                'active' => '1',
                'description' => 'Use Prepaid expenses payable to track items such as property taxes that are due, but not yet deductible as an expense because the period they cover has not yet passed.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            55 => [
                'id' => '56',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Rents in trust - Liability',
                'active' => '1',
                'description' => 'Use Rents in trust - liability to offset the Rents in trust amount in assets. Amounts in these accounts are held by your business on behalf of others. They do not belong to your business, so should not appear to be yours on your balance sheet. This "contra" account takes care of that, as long as the two balances match.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            56 => [
                'id' => '57',
                'business_id' => '0',
'account_subtype_id' => '6', 
                'name' => 'Sales and service tax payable',
                'active' => '1',
                'description' => 'Use Sales and service tax payable to track tax you have collected, but not yet remitted to your government tax agency. This includes value-added tax, goods and services tax, sales tax, and other consumption tax.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            57 => [
                'id' => '58',
                'business_id' => '0',
'account_subtype_id' => '7', 
                'name' => 'Accrued holiday payable',
                'active' => '1',
                'description' => 'Use Accrued holiday payable to track holiday earned but that has not been paid out to employees.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            58 => [
                'id' => '59',
                'business_id' => '0',
'account_subtype_id' => '7', 
                'name' => 'Accrued Non-current liabilities',
                'active' => '1',
                'description' => 'Use Accrued Non-current liabilities to track expenses that a business has incurred but has not yet paid. For example, pensions for companies that contribute to a pension fund for their employees for their retirement.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            59 => [
                'id' => '60',
                'business_id' => '0',
'account_subtype_id' => '7', 
                'name' => 'Liabilities related to assets held for sale',
                'active' => '1',
                'description' => 'Use Liabilities related to assets held for sale to track any liabilities that are directly related to assets being sold or written off.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            60 => [
                'id' => '61',
                'business_id' => '0',
'account_subtype_id' => '7', 
                'name' => 'Long-term debt',
                'active' => '1',
                'description' => 'Use Long-term debt to track loans and obligations with a maturity of longer than one year. For example, mortgages.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            61 => [
                'id' => '62',
                'business_id' => '0',
'account_subtype_id' => '7', 
                'name' => 'Notes payable',
                'active' => '1',
                'description' => 'Use Notes payable to track the amounts your business owes in long-term (over twelve months) loans. For shorter loans, use the Current liability account type called Loan payable, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            62 => [
                'id' => '63',
                'business_id' => '0',
'account_subtype_id' => '7', 
                'name' => 'Other non-current liabilities',
                'active' => '1',
                'description' => 'Use Other non-current liabilities to track liabilities due in more than twelve months that don\'t fit the other Non-Current liability account types.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            63 => [
                'id' => '64',
                'business_id' => '0',
'account_subtype_id' => '7', 
                'name' => 'Shareholder notes payable',
                'active' => '1',
                'description' => 'Use Shareholder notes payable to track long-term loan balances your business owes its shareholders.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            64 => [
                'id' => '65',
                'business_id' => '0',
'account_subtype_id' => '8', 
                'name' => 'Accounts Payable (A/P)',
                'active' => '1',
                'description' => 'Accounts payable (also called A/P, Trade and other payables, or Creditors) tracks amounts you owe to your suppliers. Ultimate POS automatically creates one Accounts Payable account for you. Most businesses need only one.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            65 => [
                'id' => '66',
                'business_id' => '0',
'account_subtype_id' => '9', 
                'name' => 'Credit Card',
                'active' => '1',
                'description' => 'Credit card accounts track the balance due on your business credit cards. Create one Credit card account for each credit card account your business uses.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            66 => [
                'id' => '67',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Accumulated Adjustment',
                'active' => '1',
                'description' => 'Some corporations use this account to track adjustments to owner\'s equity that are not attributable to net income.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            67 => [
                'id' => '68',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Dividend disbursed',
                'active' => '1',
                'description' => 'Use Dividend disbursed to track a payment given to its shareholders out of the company\'s retained earnings.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            68 => [
                'id' => '69',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Equity in earnings of subsidiaries',
                'active' => '1',
                'description' => 'Use Equity in earnings of subsidiaries to track the original investment in shares of subsidiaries plus the share of earnings or losses from the operations of the subsidiary.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            69 => [
                'id' => '70',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Opening balance equity',
                'active' => '1',
                'description' => 'Ultimate POS creates this account the first time you enter an opening balance for a balance sheet account. As you enter opening balances, Ultimate POS records the amounts in Opening balance equity. This ensures that you have a correct balance sheet for your company, even before you\'ve finished entering all your company\'s assets and liabilities.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            70 => [
                'id' => '71',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Ordinary shares',
                'active' => '1',
                'description' => 'Corporations use Ordinary shares to track its ordinary shares in the hands of shareholders. The amount in this account should be the stated (or par) value of the stock.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            71 => [
                'id' => '72',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Other comprehensive income',
                'active' => '1',
                'description' => 'Use Other comprehensive income to track the increases or decreases in income from various businesses that is not yet absorbed by the company.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            72 => [
                'id' => '73',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Owner\'s Equity',
                'active' => '1',
                'description' => 'Corporations use Owner\'s equity to show the cumulative net income or loss of their business as of the beginning of the financial year.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            73 => [
                'id' => '74',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Paid-in capital or Surplus',
                'active' => '1',
                'description' => 'Corporations use Paid-in capital to track amounts received from shareholders in exchange for shares that are over and above the shares\' stated (or par) value.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            74 => [
                'id' => '75',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Partner contributions',
                'active' => '1',
                'description' => 'Partnerships use Partner contributions to track amounts partners contribute to the partnership during the year.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            75 => [
                'id' => '76',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Partner distributions',
                'active' => '1',
                'description' => 'Partnerships use Partner distributions to track amounts distributed by the partnership to its partners during the year. Don\'t use this for regular payments to partners for interest or service. For regular payments, use a Guaranteed payments account (a Expense account in Payroll expenses), instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            76 => [
                'id' => '77',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Partner\'s Equity',
                'active' => '1',
                'description' => 'Partnerships use Partner\'s equity to show the income remaining in the partnership for each partner as of the end of the prior year.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            77 => [
                'id' => '78',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Preferred Shares',
                'active' => '1',
                'description' => 'Corporations use this account to track its preferred shares in the hands of shareholders. The amount in this account should be the stated (or par) value of the shares.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            78 => [
                'id' => '79',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Retained earnings',
                'active' => '1',
                'description' => 'Ultimate POS adds this account when you create your company. Retained earnings tracks net income from previous financial years. Ultimate POS automatically transfers your profit (or loss) to Retained earnings at the end of each financial year.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            79 => [
                'id' => '80',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Share capital',
                'active' => '1',
                'description' => 'Use Share capital to track the funds raised by issuing shares.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            80 => [
                'id' => '81',
                'business_id' => '0',
'account_subtype_id' => '10', 
                'name' => 'Treasury shares',
                'active' => '1',
                'description' => 'Corporations use Treasury shares to track amounts paid by the corporation to buy its own shares back from shareholders.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            81 => [
                'id' => '82',
                'business_id' => '0',
'account_subtype_id' => '11', 
                'name' => 'Discounts/refunds given',
                'active' => '1',
                'description' => 'Use Discounts/refunds given to track discounts you give to customers. This account typically has a negative balance so it offsets other income. For discounts from suppliers, use an expense account, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            82 => [
                'id' => '83',
                'business_id' => '0',
'account_subtype_id' => '11', 
                'name' => 'Non-profit income',
                'active' => '1',
                'description' => 'Use Non-profit income to track money coming in if you are a non-profit organisation.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            83 => [
                'id' => '84',
                'business_id' => '0',
'account_subtype_id' => '11', 
                'name' => 'Other primary income',
                'active' => '1',
                'description' => 'Use Other primary income to track income from normal business operations that doesn\'t fall into another Income type.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            84 => [
                'id' => '85',
                'business_id' => '0',
'account_subtype_id' => '11', 
                'name' => 'Revenue - General',
                'active' => '1',
                'description' => 'Use Revenue - General to track income from normal business operations that do not fit under any other category.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            85 => [
                'id' => '86',
                'business_id' => '0',
'account_subtype_id' => '11', 
                'name' => 'Sales - retail',
                'active' => '1',
                'description' => 'Use Sales - retail to track sales of goods/services that have a mark-up cost to consumers.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            86 => [
                'id' => '87',
                'business_id' => '0',
'account_subtype_id' => '11', 
                'name' => 'Sales - wholesale',
                'active' => '1',
                'description' => 'Use Sales - wholesale to track the sale of goods in quantity for resale purposes.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            87 => [
                'id' => '88',
                'business_id' => '0',
'account_subtype_id' => '11', 
                'name' => 'Sales of Product Income',
                'active' => '1',
                'description' => 'Use Sales of product income to track income from selling products. This can include all kinds of products, like crops and livestock, rental fees, performances, and food served.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            88 => [
                'id' => '89',
                'business_id' => '0',
'account_subtype_id' => '11', 
                'name' => 'Service/fee income',
                'active' => '1',
                'description' => 'Use Service/fee income to track income from services you perform or ordinary usage fees you charge. For fees customers pay you for late payments or other uncommon situations, use an Other Income account type called Other miscellaneous income, instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            89 => [
                'id' => '90',
                'business_id' => '0',
'account_subtype_id' => '11', 
                'name' => 'Unapplied Cash Payment Income',
                'active' => '1',
                'description' => 'Unapplied Cash Payment Income reports the Cash Basis income from customers payments you\'ve received but not applied to invoices or charges. In general, you would never use this directly on a purchase or sale transaction.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            90 => [
                'id' => '91',
                'business_id' => '0',
'account_subtype_id' => '12', 
                'name' => 'Dividend income',
                'active' => '1',
                'description' => 'Use Dividend income to track taxable dividends from investments.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            91 => [
                'id' => '92',
                'business_id' => '0',
'account_subtype_id' => '12', 
                'name' => 'Interest earned',
                'active' => '1',
                'description' => 'Use Interest earned to track interest from bank or savings accounts, investments, or interest payments to you on loans your business made.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            92 => [
                'id' => '93',
                'business_id' => '0',
'account_subtype_id' => '12', 
                'name' => 'Loss on disposal of assets',
                'active' => '1',
                'description' => 'Use Loss on disposal of assets to track losses realised on the disposal of assets.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            93 => [
                'id' => '94',
                'business_id' => '0',
'account_subtype_id' => '12', 
                'name' => 'Other investment income',
                'active' => '1',
                'description' => 'Use Other investment income to track other types of investment income that isn\'t from dividends or interest.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            94 => [
                'id' => '95',
                'business_id' => '0',
'account_subtype_id' => '12', 
                'name' => 'Other miscellaneous income',
                'active' => '1',
                'description' => 'Use Other miscellaneous income to track income that isn\'t from normal business operations, and doesn\'t fall into another Other Income type.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            95 => [
                'id' => '96',
                'business_id' => '0',
'account_subtype_id' => '12', 
                'name' => 'Other operating income',
                'active' => '1',
                'description' => 'Use Other operating income to track income from activities other than normal business operations. For example, Investment interest, foreign exchange gains, and rent income.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            96 => [
                'id' => '97',
                'business_id' => '0',
'account_subtype_id' => '12', 
                'name' => 'Tax-exempt interest',
                'active' => '1',
                'description' => 'Use Tax-exempt interest to record interest that isn\'t taxable, such as interest on money in tax-exempt retirement accounts, or interest from tax-exempt bonds.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            97 => [
                'id' => '98',
                'business_id' => '0',
'account_subtype_id' => '12', 
                'name' => 'Unrealised loss on securities, net of tax',
                'active' => '1',
                'description' => 'Use Unrealised loss on securities, net of tax to track losses on securities that have occurred but are yet been realised through a transaction. For example, shares whose value has fallen but that are still being held.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            98 => [
                'id' => '99',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Advertising/Promotional',
                'active' => '1',
                'description' => 'Use Advertising/promotional to track money spent promoting your company. You may want different accounts of this type to track different promotional efforts (Yellow Pages, newspaper, radio, flyers, events, and so on). If the promotion effort is a meal, use Promotional meals instead.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            99 => [
                'id' => '100',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Amortisation Expense',
                'active' => '1',
                'description' => 'Use Amortisation expense to track writing off of assets (such as intangible assets or investments) over the projected life of the assets.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            100 => [
                'id' => '101',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Auto',
                'active' => '1',
                'description' => 'Use Auto to track costs associated with vehicles. You may want different accounts of this type to track petrol, repairs, and maintenance. If your business owns a car or lorry, you may want to track its value as a Fixed Asset, in addition to tracking its expenses.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            101 => [
                'id' => '102',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Bad debt',
                'active' => '1',
                'description' => 'Use Bad debt to track debt you have written off.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            102 => [
                'id' => '103',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Bank charges',
                'active' => '1',
                'description' => 'Use Bank charges for any fees you pay to financial institutions.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            103 => [
                'id' => '104',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Charitable contributions',
                'active' => '1',
                'description' => 'Use Charitable contributions to track gifts to charity.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            104 => [
                'id' => '105',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Commissions and fees',
                'active' => '1',
                'description' => 'Use Commissions and fees to track amounts paid to agents (such as brokers) in order for them to execute a trade.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            105 => [
                'id' => '106',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Cost of labour',
                'active' => '1',
                'description' => 'Use Cost of labour to track the cost of paying employees to produce products or supply services. It includes all employment costs, including food and transportation, if applicable. This account is also available as a Cost of Sales (COS) account.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            106 => [
                'id' => '107',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Dues and subscriptions',
                'active' => '1',
                'description' => 'Use Dues and subscriptions to track dues and subscriptions related to running your business. You may want different accounts of this type for professional dues, fees for licences that can\'t be transferred, magazines, newspapers, industry publications, or service subscriptions.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            107 => [
                'id' => '108',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Equipment rental',
                'active' => '1',
                'description' => 'Use Equipment rental to track the cost of renting equipment to produce products or services. This account is also available as a Cost of Sales account. If you purchase equipment, use a Fixed asset account type called Machinery and equipment.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            108 => [
                'id' => '109',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Finance costs',
                'active' => '1',
                'description' => 'Use Finance costs to track the costs of obtaining loans or credit. Examples of finance costs would be credit card fees, interest and mortgage costs.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            109 => [
                'id' => '110',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Income tax expense',
                'active' => '1',
                'description' => 'Use Income tax expense to track income taxes that the company has paid to meet their tax obligations.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            110 => [
                'id' => '111',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Insurance',
                'active' => '1',
                'description' => 'Use Insurance to track insurance payments. You may want different accounts of this type for different types of insurance (auto, general liability, and so on).',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            111 => [
                'id' => '112',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Interest paid',
                'active' => '1',
                'description' => 'Use Interest paid for all types of interest you pay, including mortgage interest, finance charges on credit cards, or interest on loans.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            112 => [
                'id' => '113',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Legal and professional fees',
                'active' => '1',
                'description' => 'Use Legal and professional fees to track money to pay to professionals to help you run your business. You may want different accounts of this type for payments to your accountant, attorney, or other consultants.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            113 => [
                'id' => '114',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Loss on discontinued operations, net of tax',
                'active' => '1',
                'description' => 'Use Loss on discontinued operations, net of tax to track the loss realised when a part of the business ceases to operate or when a product line is discontinued.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            114 => [
                'id' => '115',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Management compensation',
                'active' => '1',
                'description' => 'Use Management compensation to track remuneration paid to Management, Executives and non-Executives. For example, salary, fees, and benefits.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            115 => [
                'id' => '116',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Meals and entertainment',
                'active' => '1',
                'description' => 'Use Meals and entertainment to track how much you spend on dining with your employees to promote morale. If you dine with a customer to promote your business, use a Promotional meals account, instead. Be sure to include who you ate with and the purpose of the meal when you enter the transaction.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            116 => [
                'id' => '117',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Office/general administrative expenses',
                'active' => '1',
                'description' => 'Use Office/general administrative expenses to track all types of general or office-related expenses.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            117 => [
                'id' => '118',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Other miscellaneous service cost',
                'active' => '1',
                'description' => 'Use Other miscellaneous service cost to track costs related to providing services that don\'t fall into another Expense type. This account is also available as a Cost of Sales (COS) account.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            118 => [
                'id' => '119',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Other selling expenses',
                'active' => '1',
                'description' => 'Use Other selling expenses to track selling expenses incurred that do not fall under any other category.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            119 => [
                'id' => '120',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Payroll expenses',
                'active' => '1',
                'description' => 'Use Payroll expenses to track payroll expenses. You may want different accounts of this type for things like: Compensation of officers, Guaranteed payments, Workers compensation, Salaries and wages, Payroll taxes',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            120 => [
                'id' => '121',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Rent or lease of buildings',
                'active' => '1',
                'description' => 'Use Rent or lease of buildings to track rent payments you make.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            121 => [
                'id' => '122',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Repair and maintenance',
                'active' => '1',
                'description' => 'Use Repair and maintenance to track any repairs and periodic maintenance fees. You may want different accounts of this type to track different types repair & maintenance expenses (auto, equipment, landscape, and so on).',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            122 => [
                'id' => '123',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Shipping and delivery expense',
                'active' => '1',
                'description' => 'Use Shipping and delivery expense to track the cost of shipping and delivery of goods to customers.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            123 => [
                'id' => '124',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Supplies & materials',
                'active' => '1',
                'description' => 'Use Supplies & materials to track the cost of raw goods and parts used or consumed when producing a product or providing a service. This account is also available as a Cost of Sales account.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            124 => [
                'id' => '125',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Taxes paid',
                'active' => '1',
                'description' => 'Use Taxes paid to track taxes you pay. You may want different accounts of this type for payments to different tax agencies.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            125 => [
                'id' => '126',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Travel expenses - general and admin expenses',
                'active' => '1',
                'description' => 'Use Travel expenses - general and admin expenses to track travelling costs incurred that are not directly related to the revenue-generating operation of the company. For example, flight tickets and hotel costs when performing job interviews.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            126 => [
                'id' => '127',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Travel expenses - selling expense',
                'active' => '1',
                'description' => 'Use Travel expenses - selling expense to track travelling costs incurred that are directly related to the revenue-generating operation of the company. For example, flight tickets and hotel costs when selling products and services.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            127 => [
                'id' => '128',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Unapplied Cash Bill Payment Expense',
                'active' => '1',
                'description' => 'Unapplied Cash Bill Payment Expense reports the Cash Basis expense from supplier payment cheques you\'ve sent but not yet applied to supplier bills. In general, you would never use this directly on a purchase or sale transaction.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            128 => [
                'id' => '129',
                'business_id' => '0',
'account_subtype_id' => '13', 
                'name' => 'Utilities',
                'active' => '1',
                'description' => 'Use Utilities to track utility payments. You may want different accounts of this type to track different types of utility payments (gas and electric, telephone, water, and so on).',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            129 => [
                'id' => '130',
                'business_id' => '0',
'account_subtype_id' => '14', 
                'name' => 'Cost of labour - COS',
                'active' => '1',
                'description' => 'Use Cost of labour - COS to track the cost of paying employees to produce products or supply services. It includes all employment costs, including food and transportation, if applicable.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            130 => [
                'id' => '131',
                'business_id' => '0',
'account_subtype_id' => '14', 
                'name' => 'Equipment rental - COS',
                'active' => '1',
                'description' => 'Use Equipment rental - COS to track the cost of renting equipment to produce products or services. If you purchase equipment, use a Fixed Asset account type called Machinery and equipment.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            131 => [
                'id' => '132',
                'business_id' => '0',
'account_subtype_id' => '14', 
                'name' => 'Freight and delivery - COS',
                'active' => '1',
                'description' => 'Use Freight and delivery - COS to track the cost of shipping/delivery of obtaining raw materials and producing finished goods for resale.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            132 => [
                'id' => '133',
                'business_id' => '0',
'account_subtype_id' => '14', 
                'name' => 'Other costs of sales - COS',
                'active' => '1',
                'description' => 'Use Other costs of sales - COS to track costs related to services or sales that you provide that don\'t fall into another Cost of Sales type.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            133 => [
                'id' => '134',
                'business_id' => '0',
'account_subtype_id' => '14', 
                'name' => 'Supplies and materials - COS',
                'active' => '1',
                'description' => 'Use Supplies and materials - COS to track the cost of raw goods and parts used or consumed when producing a product or providing a service.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            134 => [
                'id' => '135',
                'business_id' => '0',
'account_subtype_id' => '15', 
                'name' => 'Amortisation',
                'active' => '1',
                'description' => 'Use Amortisation to track amortisation of intangible assets. Amortisation is spreading the cost of an intangible asset over its useful life, like depreciation of fixed assets. You may want an amortisation account for each intangible asset you have.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            135 => [
                'id' => '136',
                'business_id' => '0',
'account_subtype_id' => '15', 
                'name' => 'Depreciation',
                'active' => '1',
                'description' => 'Use Depreciation to track how much you depreciate fixed assets. You may want a depreciation account for each fixed asset you have.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            136 => [
                'id' => '137',
                'business_id' => '0',
'account_subtype_id' => '15', 
                'name' => 'Exchange Gain or Loss',
                'active' => '1',
                'description' => 'Use Exchange Gain or Loss to track gains or losses that occur as a result of exchange rate fluctuations.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            137 => [
                'id' => '138',
                'business_id' => '0',
'account_subtype_id' => '15', 
                'name' => 'Other expense',
                'active' => '1',
                'description' => 'Use Other expense to track unusual or infrequent expenses that don\'t fall into another Other Expense type.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
            138 => [
                'id' => '139',
                'business_id' => '0',
'account_subtype_id' => '15', 
                'name' => 'Penalties and settlements',
                'active' => '1',
                'description' => 'Use Penalties and settlements to track money you pay for violating laws or regulations, settling lawsuits, or other penalties.',
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ],
        ];

        foreach ($account_detail_types as $account_detail_type) {
            AccountDetailType::insert($account_detail_type);
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
    }
}
