<?php $__env->startSection('title'); ?>
    <?php echo e($chart_of_account->name, false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(trans_choice('accounting::general.accounting', 1), false); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('subtitle'); ?>
            <?php echo e(trans_choice('accounting::lang.account', 1), false); ?> <?php echo e(trans_choice('accounting::lang.detail', 2), false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.view')): ?>
            <div class="row">

                <?php $__env->startComponent('accounting::components.box'); ?>
                    <?php $__env->slot('title'); ?>
                        <?php echo e($chart_of_account->name, false); ?>

                    <?php $__env->endSlot(); ?>

                    <?php $__env->slot('body'); ?>
                        <section class="content">
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="row">

                                        <div class="col-lg-6 col-xs-6">
                                            <div class="small-box bg-green">
                                                <div class="inner">
                                                    <h4>
                                                        <strong>
                                                            <span>&nbsp;</span>
                                                            <?php echo e(number_format($chart_of_account->opening_balance, 2), false); ?>

                                                        </strong>
                                                    </h4>
                                                    <p>
                                                        <?php echo e(trans('account.opening_balance'), false); ?>

                                                    </p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 col-xs-6">
                                            <div class="small-box bg-green">
                                                <div class="inner">
                                                    <h4>
                                                        <strong>
                                                            <span>&nbsp;</span>
                                                            <?php echo e(number_format($chart_of_account->current_balance, 2), false); ?>

                                                        </strong>
                                                    </h4>
                                                    <p>
                                                        <?php echo e(trans('accounting::lang.current'), false); ?>

                                                        <?php echo e(trans('accounting::lang.balance'), false); ?>

                                                    </p>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <table class="table">
                                                <tr>
                                                    <td><?php echo e(trans_choice('accounting::lang.currency', 1), false); ?></td>
                                                    <td><?php echo e($chart_of_account->currency->name, false); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(trans_choice('accounting::general.gl_code', 2), false); ?></td>
                                                    <td><?php echo e($chart_of_account->gl_code, false); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(trans_choice('accounting::lang.parent', 1), false); ?>

                                                        <?php echo e(trans_choice('accounting::lang.account', 1), false); ?></td>
                                                    <td><?php echo e($chart_of_account->parent->name, false); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

                                                        <?php echo e(trans_choice('accounting::lang.type', 1), false); ?></td>
                                                    <td>
                                                        <?php if($chart_of_account->account_type == 'asset'): ?>
                                                            <?php echo e(trans_choice('accounting::general.asset', 1), false); ?>

                                                        <?php elseif($chart_of_account->account_type == 'expense'): ?>
                                                            <?php echo e(trans_choice('accounting::general.expense', 1), false); ?>

                                                        <?php elseif($chart_of_account->account_type == 'equity'): ?>
                                                            <?php echo e(trans_choice('accounting::general.equity', 1), false); ?>

                                                        <?php elseif($chart_of_account->account_type == 'liability'): ?>
                                                            <?php echo e(trans_choice('accounting::general.liability', 1), false); ?>

                                                        <?php elseif($chart_of_account->account_type == 'income'): ?>
                                                            <?php echo e(trans_choice('accounting::general.income', 1), false); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(trans_choice('accounting::general.manual_entries_allowed', 1), false); ?></td>
                                                    <td>
                                                        <?php if($chart_of_account->allow_manual == 1): ?>
                                                            <?php echo e(trans_choice('accounting::lang.yes', 1), false); ?>

                                                        <?php else: ?>
                                                            <?php echo e(trans_choice('accounting::lang.no', 1), false); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td><?php echo e(trans_choice('accounting::lang.active', 1), false); ?> </td>
                                                    <td>
                                                        <?php if($chart_of_account->active == 1): ?>
                                                            <?php echo e(trans_choice('accounting::lang.yes', 1), false); ?>

                                                        <?php else: ?>
                                                            <?php echo e(trans_choice('accounting::lang.no', 1), false); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td><?php echo e(trans_choice('accounting::lang.note', 2), false); ?> </td>
                                                    <td><?php echo $chart_of_account->notes; ?></td>
                                                </tr>
                                            </table>

                                        </div>
                                    </div>
                                    <!-- /.box -->
                                </div>
                            </div>
                        </section>
                    <?php $__env->endSlot(); ?>
                <?php echo $__env->renderComponent(); ?>

                <?php $__env->startComponent('accounting::components.box'); ?>
                    <?php $__env->slot('title'); ?>
                        <?php echo e(trans_choice('accounting::general.journal', 1), false); ?> <?php echo e(trans_choice('accounting::lang.entry', 2), false); ?>

                    <?php $__env->endSlot(); ?>

                    <?php $__env->slot('body'); ?>
                        <section class="content">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <table id="journal_entries_table" class="table table-bordered table-hover">
                                                <thead>
                                                    <tr>
                                                        <th><?php echo e(trans_choice('accounting::general.gl_code', 1), false); ?></th>
                                                        <th style="text-align:right"><?php echo e(trans_choice('accounting::general.debit', 1), false); ?></th>
                                                        <th style="text-align:right"><?php echo e(trans_choice('accounting::general.credit', 1), false); ?></th>
                                                        <th style="text-align:right"><?php echo e(trans_choice('accounting::general.balance', 1), false); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        //group the results
                                                        $total_debit = 0;
                                                        $total_credit = 0;
                                                    ?>
                                                    <?php $__currentLoopData = $chart_of_account->journal_entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            //group the results
                                                            $total_debit = $total_debit + $key->debit;
                                                            $total_credit = $total_credit + $key->credit;
                                                        ?>
                                                        <tr>
                                                            <td><?php echo e($chart_of_account->gl_code, false); ?></td>
                                                            <td style="text-align:right">
                                                                <?php echo e(number_format($key->debit, 2), false); ?>

                                                            </td>
                                                            <td style="text-align:right">
                                                                <?php echo e(number_format($key->credit, 2), false); ?>

                                                            </td>
                                                            <td style="text-align:right">
                                                                <?php echo e(number_format($total_credit - $total_debit, 2), false); ?>

                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <td><b><?php echo e(trans_choice('accounting::lang.total', 1), false); ?></b></td>
                                                        <td style="text-align:right"><b><?php echo e(number_format($total_debit, 2), false); ?></b></td>
                                                        <td style="text-align:right"><b><?php echo e(number_format($total_credit, 2), false); ?></b></td>
                                                        <td style="text-align:right"><b><?php echo e(number_format($total_credit - $total_debit, 2), false); ?></b></td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.box -->
                                </div>
                            </div>
                        </section>
                    <?php $__env->endSlot(); ?>
                <?php echo $__env->renderComponent(); ?>

            </div>
        <?php endif; ?>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script>
        $('#journal_entries_table').DataTable({
            'ordering': false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/chart_of_account/show.blade.php ENDPATH**/ ?>