<div class="modal-dialog" role="document">
    <div class="modal-content">

        <form method="post" id="fund_transfer_form" action="<?php echo e(url('accounting/transfers/store'), false); ?>" enctype="multipart/form-data">
            <?php echo e(csrf_field(), false); ?>


            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><?php echo app('translator')->get('account.fund_transfer'); ?></h4>
            </div>

            <div class="modal-body">

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="location_id" class="control-label"><?php echo e(trans_choice('accounting::lang.business_location', 1), false); ?></label>
                        <select class="form-control <?php $__errorArgs = ['location_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="location_id" id="location_id"
                            v-model="location_id" required>
                            <option value="" disabled selected><?php echo e(trans_choice('accounting::lang.select', 1), false); ?></option>
                            <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id, false); ?>"><?php echo e($key->name, false); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['location_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="currency_id" class="control-label"><?php echo e(trans_choice('accounting::lang.currency', 1), false); ?></label>
                        <v-select label="currency" :options="currencies" :reduce="currency => currency.id" v-model="currency_id">
                            <template #search="{attributes, events}">
                                <input autocomplete="off" class="vs__search <?php $__errorArgs = ['currency_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    :required="!currency_id" v-bind="attributes" v-on="events" />
                            </template>
                        </v-select>
                        <input type="hidden" name="currency_id" v-model="currency_id">
                        <?php $__errorArgs = ['currency_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="amount" class="control-label"><?php echo e(trans_choice('accounting::lang.amount', 1), false); ?></label>
                        <input type="text" name="amount" v-model="amount" id="amount"
                            class="form-control numeric <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                        <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="debit" class="control-label"><?php echo e(trans_choice('accounting::general.transfer_from', 1), false); ?></label>
                        <select class="form-control <?php $__errorArgs = ['debit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="debit" id="debit" v-model="debit"
                            required>
                            <option value="" disabled selected><?php echo e(trans_choice('accounting::lang.select', 1), false); ?></option>
                            <?php $__currentLoopData = $chart_of_accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id, false); ?>"><?php echo e($key->name, false); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['debit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="credit" class="control-label"><?php echo e(trans_choice('accounting::general.transfer_to', 1), false); ?></label>
                        <select class="form-control <?php $__errorArgs = ['credit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="credit" id="credit" v-model="credit"
                            required>
                            <option value="" disabled selected><?php echo e(trans_choice('accounting::lang.select', 1), false); ?></option>
                            <?php $__currentLoopData = $chart_of_accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id, false); ?>"><?php echo e($key->name, false); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="text-danger" v-show="credit_equal_debit"><?php echo e(__('accounting::general.transfer_accounts_same'), false); ?>

                        </div>
                        <?php $__errorArgs = ['credit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <?php echo Form::label('date', __('messages.date') . ':*'); ?>

                        <div class="input-group date" id='od_datetimepicker'>
                            <?php echo Form::text('date', null, [
                                'class' => 'form-control datepicker',
                                'required',
                                'placeholder' => __('messages.date'),
                                'v-model' => 'date',
                            ]); ?>

                            <span class="input-group-addon" id="date_addon">
                                <span class="glyphicon glyphicon-calendar"></span>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="reference" class="control-label"><?php echo e(trans_choice('accounting::general.reference', 1), false); ?></label>
                        <input type="text" name="reference" v-model="reference" id="reference"
                            class="form-control <?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="payment_type_id" class="control-label"><?php echo e(trans_choice('accounting::lang.payment', 1), false); ?>

                            <?php echo e(trans_choice('accounting::lang.type', 1), false); ?></label>
                        <select class="form-control" name="payment_type_id" id="payment_type_id">
                            <?php $__currentLoopData = $payment_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($payment_type->id, false); ?>"><?php echo e($payment_type->name, false); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['payment_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="receipt" class="control-label"><?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?></label>
                        <input type="text" name="receipt" v-model="receipt" id="receipt"
                            class="form-control <?php $__errorArgs = ['receipt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['receipt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group">
                        <label for="notes" class="control-label"><?php echo e(trans_choice('accounting::lang.note', 2), false); ?></label>
                        <textarea type="text" name="notes" v-model="notes" id="notes" class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"></textarea>
                        <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                
            </div>

            <div class="modal-footer">
                <div class="text-danger" v-show="credit_equal_debit"><?php echo e(__('accounting::general.transfer_accounts_same'), false); ?></div>
                <button type="submit" class="btn btn-primary float-right"
                    :disabled="!is_btn_enabled"><?php echo e(trans_choice('accounting::lang.save', 1), false); ?></button>
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get('messages.close'); ?></button>
            </div>

        </form>

    </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->

<script>
    new Vue({
        el: '#fund_transfer_form',
        data() {
            return {
                currencies: <?php echo json_encode($currencies); ?>,
                location_id: "<?php echo e(old('location_id'), false); ?>",
                currency_id: "<?php echo e(old('currency_id'), false); ?>",
                debit: "<?php echo e(old('debit'), false); ?>",
                credit: "<?php echo e(old('credit'), false); ?>",
                amount: "<?php echo e(old('amount'), false); ?>",
                reference: "<?php echo e(old('reference'), false); ?>",
                date: "<?php echo e(old('date', date('Y-m-d')), false); ?>",
                payment_type_id: "<?php echo e(old('payment_type_id'), false); ?>",
                receipt: "<?php echo e(old('receipt'), false); ?>",
                notes: "<?php echo e(old('notes'), false); ?>",
            }
        },

        computed: {
            is_btn_enabled() {
                return !this.credit_equal_debit;
            },

            credit_equal_debit() {
                return (this.debit.trim() && this.credit.trim()) &&
                    this.debit == this.credit
            }

        }
    });

    $(document).ready(function() {
        $('.datepicker')
            .datepicker({
                format: 'yyyy-mm-dd',
                defaultDate: new Date()
            })
            .attr('readonly', '');

        $('#date_addon').on('click', function() {
            $('#date').trigger('click');
        });
    });
</script>
<?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/transfers/create.blade.php ENDPATH**/ ?>