<style>
    .table {
        width: 100%;
        border: 1px solid #ccc;
        border-collapse: collapse;
    }

    .table th,
    td {
        padding: 5px;
        text-align: left;
        border: 1px solid #ccc;
    }

    .light-heading th {
        background-color: #eeeeee
    }

    .green-heading th {
        background-color: #4CAF50;
        color: white;
    }

    .text-center {
        text-align: center;
    }

    .table-striped tr:nth-child(even) {
        background-color: #f2f2f2;
    }

    .text-danger {
        color: #a94442;
    }

    .text-success {
        color: #3c763d;
    }

</style>
<h3 class="text-center"><?php echo e(get_business_name(), false); ?></h3>
<h3 class="text-center"><?php echo e(trans_choice('accounting::general.journal', 1), false); ?></h3>
<table class="table table-striped" style="font-size: 12px">
    <thead>
        <tr>
            <th>
                <?php if(!empty($location_id) && !empty($data->first()->business_location)): ?>
                    <?php echo e(trans_choice('accounting::lang.business_location', 1), false); ?>:
                    <?php echo e($data->first()->business_location, false); ?>

                <?php endif; ?>
            </th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th><?php echo e(trans_choice('accounting::lang.start_date', 1), false); ?>: <?php echo e(readable_date($start_date), false); ?></th>
            <th><?php echo e(trans_choice('accounting::lang.end_date', 1), false); ?>: <?php echo e(readable_date($end_date), false); ?></th>
        </tr>
        <tr>
            <th>
                <?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?> <?php echo e(trans_choice('accounting::lang.date', 1), false); ?>

            </th>
            <th>
                <?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?>#
            </th>
            <th>
                <?php echo e(trans_choice('accounting::lang.type', 1), false); ?>

            </th>
            <th>
                <?php echo e(trans_choice('accounting::general.account_subtype', 1), false); ?>

            </th>
            <th>
                <?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

                <?php echo e(trans_choice('accounting::general.detail_type', 1), false); ?>

            </th>
            <th>
                <?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

            </th>
            <th>
                <?php echo e(trans_choice('accounting::lang.created_by', 1), false); ?>

            </th>
            <th style="text-align: right">
                <?php echo e(trans_choice('accounting::general.debit', 1), false); ?>

            </th>
            <th style="text-align: right">
                <?php echo e(trans_choice('accounting::general.credit', 1), false); ?>

            </th>
        </tr>
    </thead>

    <tbody>
        <?php
            $parent2_index = 1;
        ?>

        <?php $__currentLoopData = $account_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $parent1_index = $parent2_index;
            ?>
            <tr class="treegrid-<?php echo e($parent2_index, false); ?>">
                <td><?php echo e(ucfirst($account_type), false); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <?php
                $parent2_index++;
                $chart_of_account_type = $data->where('account_type', $account_type);
            ?>

            <?php $__currentLoopData = $chart_of_account_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="treegrid-<?php echo e($parent2_index, false); ?> treegrid-parent-<?php echo e($parent1_index, false); ?>">
                    <td style="min-width: 200px"><?php echo e($key->date, false); ?></td>
                    <td class="___class_+?41___">
                        <span><?php echo e($key->transaction_number, false); ?></span>
                    </td>
                    <td>
                        <?php if($key->account_type == 'asset'): ?>
                            <span><?php echo e(trans_choice('accounting::general.asset', 1), false); ?></span>
                        <?php elseif($key->account_type == 'expense'): ?>
                            <span><?php echo e(trans_choice('accounting::general.expense', 1), false); ?></span>
                        <?php elseif($key->account_type == 'equity'): ?>
                            <span><?php echo e(trans_choice('accounting::general.equity', 1), false); ?></span>
                        <?php elseif($key->account_type == 'liability'): ?>
                            <span><?php echo e(trans_choice('accounting::general.liability', 1), false); ?></span>
                        <?php elseif($key->account_type == 'income'): ?>
                            <span><?php echo e(trans_choice('accounting::general.income', 1), false); ?></span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($key->account_subtype, false); ?></td>
                    <td><?php echo e($key->account_detail_type, false); ?></td>
                    <td class="___class_+?44___">
                        <span><?php echo e($key->account_name, false); ?></span>
                    </td>
                    <td class="___class_+?42___">
                        <span><?php echo e($key->created_by, false); ?></span>
                    </td>
                    <td class="___class_+?45___" style="text-align: right">
                        <span><?php echo e(number_format($key->debit), false); ?></span>
                    </td>
                    <td class="___class_+?46___" style="text-align: right">
                        <span><?php echo e(number_format($key->credit), false); ?></span>
                    </td>
                    <?php
                        $parent2_index++;
                    ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <tr class="font-weight-bold bg-subtotal">
                <td>
                    <?php echo e(trans('accounting::lang.total_for'), false); ?> <?php echo e($account_type, false); ?>

                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td class="text-right">
                    <?php echo e(number_format($chart_of_account_type->sum('debit'), 2), false); ?>

                </td>
                <td class="text-right">
                    <?php echo e(number_format($chart_of_account_type->sum('credit'), 2), false); ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <tr class="font-weight-bold bg-grand-total">
            <td>
                <?php echo e(trans('accounting::lang.grand_total'), false); ?>

            </td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td class="text-right">
                <?php echo e(number_format($data->sum('debit'), 2), false); ?>

            </td>
            <td class="text-right">
                <?php echo e(number_format($data->sum('credit'), 2), false); ?>

            </td>
        </tr>
    </tbody>
</table>
<?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/report/journal_pdf.blade.php ENDPATH**/ ?>