<?php $__env->startSection('tab-title'); ?>
    <?php echo e(trans_choice('accounting::general.account_subtype', 2), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('tab-content'); ?>
    <!-- Main content -->
    <section class="content no-print" id="vue-app">
        <div class="row">

            <?php $__env->startComponent('accounting::components.box'); ?>
                <?php $__env->slot('title'); ?>
                    <?php echo e(trans_choice('accounting::general.account_subtype', 1), false); ?>

                    #<?php echo e($account_subtype->id, false); ?>

                <?php $__env->endSlot(); ?>

                <?php $__env->slot('body'); ?>
                    <!-- Main content -->
                    <section class="content" id="vue-app">
                        <div class="card">

                            <form action="<?php echo e(url('accounting/settings/account_subtypes/' . $account_subtype->id . '/update'), false); ?>" method="post">
                                <div class="card-body p-0">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label for="account_type" class="control-label"><?php echo e(trans_choice('accounting::general.account', 1), false); ?>

                                            <?php echo e(trans_choice('accounting::lang.type', 1), false); ?></label>
                                        <v-select label="name" :options="account_types" :reduce="account => account.id" v-model="account_subtype.id">
                                            <template #search="{attributes, events}">
                                                <input autocomplete="off" class="vs__search <?php $__errorArgs = ['account_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    v-bind="attributes" v-bind:required="!account_subtype.id" v-on="events" />
                                            </template>
                                        </v-select>
                                        <input type="hidden" name="account_type" v-model="account_subtype.id">
                                        <?php $__errorArgs = ['account_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($message, false); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="name"><?php echo e(trans('accounting::lang.name'), false); ?></label>
                                        <input class="form-control" type="text" name="name" v-model="name">
                                    </div>

                                    <div class="form-group">
                                        <label for="description"><?php echo e(trans('accounting::lang.description'), false); ?></label>
                                        <textarea class="form-control" type="text" name="description" v-model="description"></textarea>
                                    </div>

                                    <div class="form-group">
                                        <div class="checkbox">
                                            <label>
                                                <input class="input-icheck" name="active" type="checkbox" v-model="active">
                                                <?php echo e(trans('accounting::lang.active'), false); ?>

                                            </label>
                                        </div>
                                    </div>

                                </div>

                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary float-right"><?php echo e(trans_choice('accounting::lang.save', 1), false); ?></button>
                                </div>

                            </form>

                        </div>
                    </section>
                <?php $__env->endSlot(); ?>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('tab-javascript'); ?>
    <script>
        const app = new Vue({
            el: '#vue-app',
            data: {
                account_types: <?php echo json_encode($account_types); ?>,
                account_subtype: {
                    id: "<?php echo e(old('account_type', $account_subtype->account_type), false); ?>",
                    name: "<?php echo e(old('account_type', $account_subtype->account_type), false); ?>"
                },
                name: "<?php echo e(old('name', $account_subtype->name), false); ?>",
                description: "<?php echo e(old('description', $account_subtype->description), false); ?>",
                active: <?php echo e(old('active', $account_subtype->active) ? 1 : 0, false); ?>,
            },
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::settings.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/settings/account_subtypes/edit.blade.php ENDPATH**/ ?>