<?php $__env->startSection('tab-title'); ?>
    <?php echo e(trans_choice('accounting::general.expense', 2), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal-content'); ?>
    <?php echo $__env->make('accounting::transactions.partials.map_transactions_modal', [
        'map_type' => 'debit',
        'mapping_for' => 'expense',
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('tab-content'); ?>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
                    <div class="row">
                        <?php if(auth()->user()->can('all_expense.access')): ?>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?php echo Form::label('location_id', __('purchase.business_location') . ':'); ?>

                                    <?php echo Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'style' => 'width:100%']); ?>

                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <?php echo Form::label('expense_for', __('expense.expense_for') . ':'); ?>

                                    <?php echo Form::select('expense_for', $users, null, ['class' => 'form-control select2', 'style' => 'width:100%']); ?>

                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="col-md-4">
                            <div class="form-group">
                                <?php echo Form::label('expense_category_id', __('expense.expense_category') . ':'); ?>

                                <?php echo Form::select('expense_category_id', $categories, null, ['placeholder' => __('report.all'), 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'expense_category_id']); ?>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <?php echo Form::label('expense_date_range', __('report.date_range') . ':'); ?>

                                <?php echo Form::text('date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'expense_date_range', 'readonly']); ?>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <?php echo Form::label('expense_payment_status', __('purchase.payment_status') . ':'); ?>

                                <?php echo Form::select('expense_payment_status', ['paid' => __('lang_v1.paid'), 'due' => __('lang_v1.due'), 'partial' => __('lang_v1.partial')], null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all')]); ?>

                            </div>
                        </div>
                    </div>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => '']); ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="expense_transactions_table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('accounting::general.mapping'); ?></th>
                                    <th><?php echo e(trans_choice('accounting::general.chart_of_account', 1), false); ?></th>
                                    <th><?php echo app('translator')->get('messages.date'); ?></th>
                                    <th><?php echo app('translator')->get('purchase.ref_no'); ?></th>
                                    <th><?php echo app('translator')->get('lang_v1.recur_details'); ?></th>
                                    <th><?php echo app('translator')->get('expense.expense_category'); ?></th>
                                    <th><?php echo app('translator')->get('business.location'); ?></th>
                                    <th><?php echo app('translator')->get('sale.payment_status'); ?></th>
                                    <th class="d-none"><?php echo app('translator')->get('product.tax'); ?></th>
                                    <th><?php echo app('translator')->get('sale.total_amount'); ?></th>
                                    <th><?php echo app('translator')->get('purchase.payment_due'); ?>
                                    <th><?php echo app('translator')->get('expense.expense_for'); ?></th>
                                    <th><?php echo app('translator')->get('contact.contact'); ?></th>
                                    <th><?php echo app('translator')->get('expense.expense_note'); ?></th>
                                    <th><?php echo app('translator')->get('lang_v1.added_by'); ?></th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr class="bg-gray font-17 text-center footer-total">
                                    <td colspan="7"><strong><?php echo app('translator')->get('sale.total'); ?>:</strong></td>
                                    <td class="footer_payment_status_count"></td>
                                    <td></td>
                                    <td class="footer_expense_total"></td>
                                    <td class="footer_total_due"></td>
                                    <td colspan="4"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>

    </section>
    <!-- /.content -->
    <!-- /.content -->
    <div class="modal fade payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>

    <div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('tab-javascript'); ?>
    
    <script src="<?php echo e(Module::asset('accounting:js/accounting_transactions.js'), false); ?>"></script>
    
    <script src="<?php echo e(Module::asset('accounting:js/expense_transactions.js'), false); ?>"></script>
    <script src="<?php echo e(asset('js/payment.js?v=' . $asset_v), false); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.transactions_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/transactions/expenses.blade.php ENDPATH**/ ?>