<form action="<?php echo e(url('accounting/reconcile/start'), false); ?>" method="post">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="chart_of_account_name" v-model="chart_of_account.name">

    <div class="row">
        <div class="form-group col-4 pl-1">
            <label><?php echo e(trans('accounting::lang.which_account_to_reconcile'), false); ?></label>
        </div>
    </div>

    <div class="row">
        <div class="form-group col-md-12">
            <label for="chart_of_account_id" class="control-label"><?php echo e(trans_choice('accounting::general.account', 1), false); ?></label>
            <v-select label="name_with_subtype" :options="chart_of_accounts" :reduce="account => account.id"
                v-model="chart_of_account_id">
                <template #search="{attributes, events}">
                    <input autocomplete="off" class="vs__search <?php $__errorArgs = ['chart_of_account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        v-bind="attributes" v-bind:required="!chart_of_account_id" v-on="events" />
                </template>
            </v-select>
            <input type="hidden" name="chart_of_account_id" v-model="chart_of_account_id">
            <?php $__errorArgs = ['chart_of_account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback" role="alert">
                    <strong><?php echo e($message, false); ?></strong>
                </span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>

    <div class="row">
        <div class="form-group col-4 pl-1">
            <label><?php echo e(trans('accounting::lang.add_the_following_information'), false); ?></label>
        </div>
    </div>

    <div class="row">
        <div class="form-group col-md-4">
            <label for="opening_balance"
                class="control-label"><?php echo e(trans_choice('account.opening_balance', 1), false); ?></label>
            <input class="form-control" v-model="chart_of_account.last_opening_balance" type="text" name="opening_balance"
                id="opening_balance" readonly>
            <?php $__errorArgs = ['opening_balance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback" role="alert">
                    <strong><?php echo e($message, false); ?></strong>
                </span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="form-group col-md-4">
            <label for="ending_balance"
                class="control-label"><?php echo e(trans_choice('accounting::lang.ending_balance', 1), false); ?></label>
            <input class="form-control" v-model="ending_balance" type="text" name="ending_balance" id="ending_balance">
            <?php $__errorArgs = ['ending_balance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback" role="alert">
                    <strong><?php echo e($message, false); ?></strong>
                </span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="form-group col-md-4">
            <label for="ending_date" class="control-label"><?php echo e(trans_choice('accounting::lang.ending_date', 1), false); ?></label>
            <input class="form-control datepicker" v-model="ending_date" type="text" name="ending_date" id="ending_date">
            <?php $__errorArgs = ['ending_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback" role="alert">
                    <strong><?php echo e($message, false); ?></strong>
                </span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>

    <div class="form-group">
        <div class="btn-group float-right">
            <button type="button" class="btn btn-danger" @click="storeUndoReconciliation" 
                :disabled="chart_of_account.last_reconcile_transaction_id == null">
                <?php echo e(trans('accounting::lang.undo_last_reconciliation'), false); ?>

            </button>
            <button type="submit" class="btn btn-primary">
                <?php echo e(trans('accounting::lang.reconcile'), false); ?>

            </button>
        </div>
    </div>
</form><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/reconcile/partials/reconcile_form.blade.php ENDPATH**/ ?>