<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('accounting::report.profit_and_loss', 1), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('accounting::report.partials.report_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(trans_choice('accounting::general.accounting', 1), false); ?> <?php echo e(trans_choice('accounting::lang.report', 2), false); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('subtitle'); ?>
            <?php echo e(trans_choice('accounting::report.profit_and_loss', 1), false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">
        <div class="row">

            <?php $__env->startComponent('accounting::components.box'); ?>
                <?php $__env->slot('header'); ?>
                    <div class="box-tools">
                        <?php $__env->startComponent('accounting::components.download_action_button', [
                            'url' => 'report/accounting/profit_and_loss',
                            'filters' => 'start_date=' . $start_date . '&end_date=' . $end_date . '&location_id=' . $location_id,
                            ]); ?>
                        <?php echo $__env->renderComponent(); ?>
                    </div>
                <?php $__env->endSlot(); ?>

                <?php $__env->slot('body'); ?>
                    <section class="content">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <?php echo e(trans_choice('accounting::report.profit_and_loss', 1), false); ?>

                                    <?php if(!empty($start_date)): ?>
                                        <?php echo e(trans('accounting::lang.for_period'), false); ?>: <b><?php echo e($start_date, false); ?> <?php echo e(trans('accounting::lang.to'), false); ?>

                                            <?php echo e($end_date, false); ?></b>
                                    <?php endif; ?>
                                </h4>
                            </div>
                            <div class="card-body">
                                <form method="get" action="<?php echo e(Request::url(), false); ?>" class="___class_+?23___">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label"
                                                    for="location_id"><?php echo e(trans_choice('accounting::lang.business_location', 1), false); ?></label>
                                                <select class="form-control" name="location_id" id="location_id" required>
                                                    <option value="" disabled selected><?php echo e(trans_choice('accounting::lang.select', 1), false); ?></option>
                                                    <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key->id, false); ?>" <?php if($location_id == $key->id): ?> selected <?php endif; ?>>
                                                            <?php echo e($key->name, false); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label"
                                                    for="start_date"><?php echo e(trans_choice('accounting::lang.start_date', 1), false); ?></label>
                                                <input type="text" value="<?php echo e($start_date, false); ?>"
                                                    class="form-control datepicker <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="start_date"
                                                    id="start_date" required>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label"
                                                    for="end_date"><?php echo e(trans_choice('accounting::lang.end_date', 1), false); ?></label>
                                                <input type="text" value="<?php echo e($end_date, false); ?>"
                                                    class="form-control datepicker <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="end_date"
                                                    id="end_date" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-2 float-right filter-btn-row">
                                            <span class="input-group-btn">
                                                <button type="submit" class="btn bg-olive btn-flat"><?php echo e(trans_choice('accounting::lang.submit', 1), false); ?>

                                                </button>
                                            </span>
                                            <span class="input-group-btn">
                                                <a href="<?php echo e(Request::url(), false); ?>"
                                                    class="btn btn-danger btn-flat pull-right"><?php echo e(trans_choice('accounting::lang.clear', 1), false); ?>!</a>
                                            </span>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- /.box-body -->

                        </div>
                        <!-- /.box -->
                        <?php if(!empty($start_date)): ?>
                            <div style="text-align: center; border: hidden">
                                <h3><?php echo e(trans_choice('accounting::report.profit_and_loss', 1), false); ?></h3>
                            </div>
                            <?php $__env->startComponent('accounting::components.tree_view_table', ['table_responsive' => true]); ?>
                                <thead>
                                    <tr>
                                        <th>
                                            <?php if(!empty($location_id) && !empty($data->first()->business_location)): ?>
                                                <?php echo e(trans_choice('accounting::lang.business_location', 1), false); ?>:
                                                <?php echo e($data->first()->business_location, false); ?>

                                            <?php endif; ?>
                                        </th>
                                        <th></th>
                                        <th></th>
                                        <th><?php echo e(trans_choice('accounting::lang.start_date', 1), false); ?>: <?php echo e(readable_date($start_date), false); ?></th>
                                        <th><?php echo e(trans_choice('accounting::lang.end_date', 1), false); ?>: <?php echo e(readable_date($end_date), false); ?></th>
                                    </tr>
                                    <tr>
                                        <th><?php echo e(trans_choice('accounting::lang.account', 1), false); ?></th>
                                        <th><?php echo e(trans_choice('accounting::general.gl_code', 1), false); ?></th>
                                        <th style="text-align:right"><?php echo e(trans_choice('accounting::general.debit', 1), false); ?></th>
                                        <th style="text-align:right"><?php echo e(trans_choice('accounting::general.credit', 1), false); ?></th>
                                        <th style="text-align:right"><?php echo e(trans_choice('accounting::general.balance', 1), false); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php
                                        $parent2_index = 1;
                                    ?>

                                    <?php $__currentLoopData = $account_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $parent1_index = $parent2_index;
                                            $class_name = $account_type == 'income' ? 'text-success' : 'text-danger';
                                        ?>
                                        <tr class="treegrid-<?php echo e($parent2_index, false); ?>">
                                            <td>
                                                <?php echo e(ucfirst($account_type), false); ?></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <?php
                                            $parent2_index++;
                                            $chart_of_account_type = $data->where('account_type', $account_type);
                                        ?>

                                        <?php $__currentLoopData = $chart_of_account_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart_of_account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="treegrid-<?php echo e($parent2_index, false); ?> treegrid-parent-<?php echo e($parent1_index, false); ?>">
                                                <td style="min-width: 200px"><?php echo e($chart_of_account->name, false); ?></td>
                                                <td><?php echo e($chart_of_account->gl_code, false); ?></td>
                                                <td style="text-align:right"><?php echo e(number_format($chart_of_account->debit, 2), false); ?></td>
                                                <td style="text-align:right"><?php echo e(number_format($chart_of_account->credit, 2), false); ?></td>
                                                <td style="text-align:right">
                                                    <?php echo e(number_format($chart_of_account->credit - $chart_of_account->debit, 2), false); ?>

                                                </td>
                                            </tr>
                                            <?php
                                                $parent2_index++;
                                            ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <tr class="font-weight-bold bg-subtotal <?php echo e($class_name, false); ?>">
                                            <td>
                                                <?php echo e(trans('accounting::lang.total_for'), false); ?> <?php echo e($account_type, false); ?>

                                            </td>
                                            <td></td>
                                            <td style="text-align:right"><?php echo e(number_format($chart_of_account_type->sum('debit'), 2), false); ?></td>
                                            <td style="text-align:right"><?php echo e(number_format($chart_of_account_type->sum('credit'), 2), false); ?></td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format($chart_of_account_type->sum('credit') - $chart_of_account_type->sum('debit'), 2), false); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <tr class="font-weight-bold bg-grand-total">
                                        <td>
                                            <?php echo e(trans_choice('accounting::general.net_income', 1), false); ?>

                                        </td>
                                        <td></td>
                                        <td style="text-align:right"><?php echo e(number_format($data->sum('debit'), 2), false); ?></td>
                                        <td style="text-align:right"><?php echo e(number_format($data->sum('credit'), 2), false); ?></td>
                                        <td style="text-align:right">
                                            <?php echo e(number_format($data->sum('credit') - $data->sum('debit'), 2), false); ?>

                                        </td>
                                    </tr>
                                </tbody>
                            <?php echo $__env->renderComponent(); ?>
                        <?php endif; ?>
                    </section>
                <?php $__env->endSlot(); ?>
            <?php echo $__env->renderComponent(); ?>


        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <?php echo $__env->make('accounting::report.partials.report_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/report/profit_and_loss.blade.php ENDPATH**/ ?>