<?php $__env->startSection('title'); ?>
    <?php echo $__env->yieldContent('tab-title'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <section class="content-header">
        <h1>
            <?php echo $__env->yieldContent('tab-title'); ?>
        </h1>
    </section>

    
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                
                <div class="col-xs-12 pos-tab-container">
                    <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2 pos-tab-menu">
                        
                        <div class="list-group-link">
                            <?php
                                $nav_items = [
                                    'accounting/transactions/sales?type=payment' => trans_choice('accounting::general.sales', 2),
                                    'accounting/transactions/expenses' => trans_choice('accounting::general.expense', 2),
                                    'accounting/transactions/purchases?type=purchase_order' => trans_choice('accounting::general.purchase', 2),
                                ];
                                
                                function isActiveTab($url)
                                {
                                    $first_two_segments = request()->segment(1) . '/' . request()->segment(2) . '/' . request()->segment(3);
                                    return $first_two_segments == getUrlWithoutParams($url);
                                }
                            ?>

                            
                            <?php $__currentLoopData = $nav_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $url => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(url($url), false); ?>"
                                    class="list-group-item text-center <?php if(isActiveTab($url)): ?> active <?php endif; ?>">
                                    <?php echo e($label, false); ?>

                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                    <div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 pos-tab">
                        <?php echo $__env->yieldContent('tab-content'); ?>
                    </div>
                </div>
                
                <?php echo $__env->yieldContent('modal-content'); ?>
            </div>
        </div>
    </section>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <?php echo $__env->yieldContent('tab-javascript'); ?>
    <script>
        const hello = new Vue({
            el: '#mapTransactionsModal',
            data() {
                return {
                    chart_of_accounts: <?php echo json_encode($chart_of_accounts); ?>,
                    chart_of_account_id: '<?php echo e(old('chart_of_account_id'), false); ?>'
                }
            },
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/layouts/transactions_layout.blade.php ENDPATH**/ ?>