<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('accounting::lang.add', 1), false); ?> <?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(Module::asset('accounting:css/plugins/vue.custom.css'), false); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(trans_choice('accounting::general.accounting', 1), false); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('subtitle'); ?>
            <?php echo e(trans_choice('accounting::lang.add', 1), false); ?> <?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.view')): ?>
            <div class="row">

                <?php $__env->startComponent('accounting::components.box'); ?>
                    <?php $__env->slot('body'); ?>
                        <section class="content" v-cloak>
                            <form method="post" action="<?php echo e(url('accounting/chart_of_account/store'), false); ?>">
                                <?php echo e(csrf_field(), false); ?>

                                <div class="card card-bordered card-preview">
                                    <div class="card-body">

                                        <div class="row gy-4">
                                            <div class="col-md-12">
                                                <input type="hidden" name="date" value="<?php echo e(date('Y-m-d'), false); ?>">

                                                <div class="form-group">
                                                    <label for="account_type" class="control-label"><?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

                                                        <?php echo e(trans_choice('accounting::lang.type', 1), false); ?></label>
                                                    <select class="form-control <?php $__errorArgs = ['account_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="account_type"
                                                        id="account_type" v-model="account_type" v-on:change="resetAccountSubtypeAndDetailTypeId">
                                                        <option value="" disabled></option>
                                                        <option v-for="account_type in account_types" :value="account_type.id">
                                                            {{ account_type.name }}
                                                        </option>
                                                    </select>
                                                    <?php $__errorArgs = ['account_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="account_subtype_id"
                                                        class="control-label"><?php echo e(trans_choice('accounting::general.account_subtype', 1), false); ?></label>
                                                    <v-select label="name" :options="filtered_account_subtypes" :reduce="account => account.id"
                                                        v-model="account_subtype_id" v-on:input="resetDetailAndParentId">
                                                        <template #search="{attributes, events}">
                                                            <input autocomplete="off" class="vs__search <?php $__errorArgs = ['account_subtype_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                v-bind="attributes" v-bind:required="!account_subtype_id" v-on="events" />
                                                        </template>
                                                    </v-select>
                                                    <input type="hidden" name="account_subtype_id" v-model="account_subtype_id">
                                                    <?php $__errorArgs = ['account_subtype_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="detail_type_id" class="control-label"><?php echo e(trans_choice('accounting::general.account', 1), false); ?>

                                                        <?php echo e(trans_choice('accounting::general.detail_type', 1), false); ?></label>
                                                    <v-select label="name" :options="filtered_account_detail_types" :reduce="account => account.id"
                                                        v-model="detail_type_id">
                                                        <template #search="{attributes, events}">
                                                            <input autocomplete="off" class="vs__search <?php $__errorArgs = ['detail_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                v-bind="attributes" v-bind:required="!detail_type_id" v-on="events" />
                                                        </template>
                                                    </v-select>
                                                    <input type="hidden" name="detail_type_id" v-model="detail_type_id">

                                                    <div v-if="account_detail_type.description">
                                                        <div class="alert alert-info">
                                                            {{ account_detail_type.description }}
                                                        </div>
                                                    </div>

                                                    <?php $__errorArgs = ['detail_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="parent_id" class="control-label"><?php echo e(trans_choice('accounting::lang.parent', 1), false); ?></label>
                                                    <select class="form-control <?php $__errorArgs = ['parent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="parent_id" id="parent_id"
                                                        v-model="parent_id">
                                                        <option value=""></option>
                                                        <option v-for="account in filtered_chart_of_accounts" :value="account.id">{{ account.name }}
                                                        </option>
                                                    </select>
                                                    <?php $__errorArgs = ['parent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="name" class="control-label"><?php echo e(trans_choice('accounting::lang.name', 1), false); ?></label>
                                                    <input type="text" name="name" v-model="name" id="name"
                                                        class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="gl_code"
                                                        class="control-label"><?php echo e(trans_choice('accounting::general.gl_code', 1), false); ?></label>
                                                    <input type="number" name="gl_code" v-model="gl_code" id="gl_code"
                                                        class="form-control <?php $__errorArgs = ['gl_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                    <?php $__errorArgs = ['gl_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="allow_manual"
                                                        class="control-label"><?php echo e(trans_choice('accounting::general.manual_entries_allowed', 1), false); ?></label>
                                                    <select class="form-control <?php $__errorArgs = ['allow_manual'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="allow_manual"
                                                        id="allow_manual" v-model="allow_manual">
                                                        <option value="0"><?php echo e(trans_choice('accounting::lang.no', 1), false); ?></option>
                                                        <option value="1"><?php echo e(trans_choice('accounting::lang.yes', 1), false); ?></option>
                                                    </select>
                                                    <?php $__errorArgs = ['allow_manual'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="currency_id"
                                                        class="control-label"><?php echo e(trans_choice('accounting::lang.currency', 1), false); ?></label>
                                                    <v-select label="currency" :options="currencies" :reduce="currency => currency.id"
                                                        v-model="currency_id">
                                                        <template #search="{attributes, events}">
                                                            <input autocomplete="off" class="vs__search <?php $__errorArgs = ['currency_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                :required="!currency_id" v-bind="attributes" v-on="events" />
                                                        </template>
                                                    </v-select>
                                                    <input type="hidden" name="currency_id" v-model="currency_id">
                                                    <?php $__errorArgs = ['currency_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($message, false); ?></strong>
                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="active" class="control-label"><?php echo e(trans_choice('accounting::lang.active', 1), false); ?></label>
                                            <select class="form-control <?php $__errorArgs = ['active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="active" id="active"
                                                v-model="active">
                                                <option value="0"><?php echo e(trans_choice('accounting::lang.no', 1), false); ?></option>
                                                <option value="1"><?php echo e(trans_choice('accounting::lang.yes', 1), false); ?></option>
                                            </select>
                                            <?php $__errorArgs = ['active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message, false); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group">
                                            <label for="notes" class="control-label"><?php echo e(trans_choice('accounting::lang.note', 2), false); ?></label>
                                            <textarea type="text" name="notes" v-model="notes" id="notes" class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"></textarea>
                                            <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message, false); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group">
                                            <div class="checkbox">
                                                <label>
                                                    <input name="has_opening_balance" type="checkbox" v-model="has_opening_balance">
                                                    <?php echo e(trans('accounting::general.has_opening_balance'), false); ?>

                                                </label>
                                            </div>
                                        </div>

                                        <div v-if="has_opening_balance">

                                            <div class="form-group">
                                                <label for="opening_balance"
                                                    class="control-label"><?php echo e(trans_choice('account.opening_balance', 1), false); ?></label>
                                                <input type="number" name="opening_balance" v-model="opening_balance" id="opening_balance"
                                                    class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong><?php echo e($message, false); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="form-group">
                                                <label for="payment_type_id" class="control-label"><?php echo e(trans_choice('accounting::lang.payment', 1), false); ?>

                                                    <?php echo e(trans_choice('accounting::lang.type', 1), false); ?></label>
                                                <select class="form-control" name="payment_type_id" id="payment_type_id">
                                                    <?php $__currentLoopData = $payment_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($payment_type->id, false); ?>"><?php echo e($payment_type->name, false); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['payment_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong><?php echo e($message, false); ?></strong>
                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            

                                        </div>

                                    </div>
                                    <div class="card-footer border-top">
                                        <button type="submit"
                                            class="btn btn-primary float-right"><?php echo e(trans_choice('accounting::lang.save', 1), false); ?></button>
                                    </div>
                                </div><!-- .card-preview -->
                            </form>
                        </section>
                    <?php $__env->endSlot(); ?>
                <?php echo $__env->renderComponent(); ?>

            </div>
        <?php endif; ?>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script>
        var app = new Vue({
            el: "#vue-app",
            data: {
                name: "<?php echo e(old('name'), false); ?>",
                account_type: "<?php echo e(old('account_type'), false); ?>",
                parent_id: "<?php echo e(old('parent_id'), false); ?>",
                gl_code: "<?php echo e(old('gl_code'), false); ?>",
                allow_manual: "<?php echo e(old('allow_manual', 1), false); ?>",
                active: "<?php echo e(old('active', 1), false); ?>",
                notes: "<?php echo e(old('notes'), false); ?>",
                currencies: <?php echo json_encode($currencies); ?>,
                currency_id: "<?php echo e(old('currency_id'), false); ?>",
                opening_balance: "<?php echo e(old('opening_balance'), false); ?>",
                has_opening_balance: <?php echo e(old('has_opening_balance') ? 1 : 0, false); ?>,
                payment_type_id: "<?php echo e(old('payment_type_id'), false); ?>",
                // receipt: "<?php echo e(old('receipt'), false); ?>",
                chart_of_accounts: <?php echo json_encode($chart_of_accounts); ?>,
                account_types: <?php echo json_encode($account_types); ?>,
                account_subtypes: <?php echo json_encode($account_subtypes); ?>,
                account_detail_types: <?php echo json_encode($account_detail_types); ?>,
                account_subtype_id: "<?php echo e(old('account_subtype_id'), false); ?>",
                detail_type_id: "<?php echo e(old('detail_type_id'), false); ?>",
            },

            computed: {
                filtered_account_subtypes() {
                    return this.account_subtypes.filter(account => account.account_type == this.account_type);
                },

                filtered_account_detail_types() {
                    return this.account_detail_types.filter(account => account.account_subtype_id == this.account_subtype_id);
                },

                filtered_chart_of_accounts() {
                    return this.account_subtype_id ?
                        this.chart_of_accounts.filter(account => account.account_subtype_id == this.account_subtype_id) :
                        null;
                },

                account_detail_type() {
                    return this.detail_type_id ?
                        this.account_detail_types.find(account => account.id == this.detail_type_id) : {};
                }
            },

            methods: {
                resetAccountSubtypeAndDetailTypeId() {
                    // Reset the account_subtype_id when the account_type is changed to avoid choosing an account_type_id that
                    // does not belong to that account_type
                    this.account_subtype_id = null;
                    this.detail_type_id = null;
                },

                resetDetailAndParentId() {
                    // Reset the detail_type_id when the account_subtype is changed to avoid choosing an detail_type_id that
                    // does not belong to that account_subtype
                    this.detail_type_id = null;
                    this.parent_id = null;
                },
            }
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/chart_of_account/create.blade.php ENDPATH**/ ?>