<style>
    .table {
        width: 100%;
        border: 1px solid #ccc;
        border-collapse: collapse;
    }

    .table th,
    td {
        padding: 5px;
        text-align: left;
        border: 1px solid #ccc;
    }

    .light-heading th {
        background-color: #eeeeee;
    }

    .green-heading th {
        background-color: #4CAF50;
        color: white;
    }

    .text-center {
        text-align: center;
    }

    .table-striped tr:nth-child(even) {
        background-color: #f2f2f2;
    }

    .text-danger {
        color: #a94442;
    }

    .text-success {
        color: #3c763d;
    }

    .font-weight-bold {
        font-weight: bold;
    }

    .bg-subtotal {
        background-color: #f0f0f0;
    }

    .bg-grand-total {
        background-color: #d0d0d0;
    }
</style>

<h3 class="text-center"><?php echo e(get_business_name(), false); ?></h3>
<h3 class="text-center"><?php echo e(trans_choice('accounting::general.trial_balance', 1), false); ?></h3>
<table class="table table-striped">
    <thead>
        <tr>
            <th>
                <?php if(!empty($location_id) && !empty($data->first()->business_location)): ?>
                    <?php echo e(trans_choice('accounting::lang.business_location', 1), false); ?>: <?php echo e($data->first()->business_location, false); ?>

                <?php endif; ?>
            </th>
            <th></th>
            <th><?php echo e(trans_choice('accounting::lang.start_date', 1), false); ?>: <?php echo e(readable_date($start_date), false); ?></th>
            <th><?php echo e(trans_choice('accounting::lang.end_date', 1), false); ?>: <?php echo e(readable_date($end_date), false); ?></th>
        </tr>
        <tr>
            <th><?php echo e(trans_choice('accounting::lang.account', 1), false); ?></th>
            <th><?php echo e(trans_choice('accounting::general.gl_code', 1), false); ?></th>
            <th style="text-align:right"><?php echo e(trans_choice('accounting::general.debit', 1), false); ?></th>
            <th style="text-align:right"><?php echo e(trans_choice('accounting::general.credit', 1), false); ?></th>
        </tr>
    </thead>

    <tbody>
        <?php
            $parent2_index = 1;
        ?>

        <?php $__currentLoopData = $account_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $parent1_index = $parent2_index;
            ?>
            <tr class="treegrid-<?php echo e($parent2_index, false); ?>">
                <td><?php echo e(ucfirst($account_type), false); ?></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <?php
                $parent2_index++;
                $chart_of_account_type = $data->where('account_type', $account_type);
            ?>

            <?php $__currentLoopData = $chart_of_account_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart_of_account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $debit = $chart_of_account->debit;
                                        $credit = $chart_of_account->credit;

                                        if ($account_type == 'asset') {
                                            $balance = $debit - $credit;
                                            $debit_display = $balance;
                                            $credit_display = 0;
                                        } else {
                                            $debit_display = $debit;
                                            $credit_display = $credit;
                                        }
                                    ?>
                                    <tr class="treegrid-<?php echo e($parent2_index, false); ?> treegrid-parent-<?php echo e($parent1_index, false); ?>">
                                        <td style="min-width: 200px"><?php echo e($chart_of_account->name, false); ?></td>
                                        <td><?php echo e($chart_of_account->gl_code, false); ?></td>
                                        <td style="text-align:right"><?php echo e(number_format($debit_display, 2), false); ?></td>
                                        <td style="text-align:right"><?php echo e(number_format($credit_display, 2), false); ?></td>
                                    </tr>
                                    <?php
                                        $parent2_index++;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($account_type == 'asset'): ?>
                <tr class="font-weight-bold bg-subtotal">
                    <td><?php echo e(trans('accounting::lang.total_for'), false); ?> <?php echo e($account_type, false); ?></td>
                    <td></td>
                    <td style="text-align:right">
                        <?php
                            $total_balance = $chart_of_account_type->sum(function($chart_of_account) {
                                return $chart_of_account->debit - $chart_of_account->credit;
                            });
                        ?>
                        <?php echo e(number_format($total_balance, 2), false); ?>

                    </td>
                    <td></td>
                </tr>
            <?php else: ?>
                <tr class="font-weight-bold bg-subtotal">
                    <td><?php echo e(trans('accounting::lang.total_for'), false); ?> <?php echo e($account_type, false); ?></td>
                    <td></td>
                    <td style="text-align:right"><?php echo e(number_format($chart_of_account_type->sum('debit'), 2), false); ?></td>
                    <td style="text-align:right"><?php echo e(number_format($chart_of_account_type->sum('credit'), 2), false); ?></td>
                </tr>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <tr class="font-weight-bold bg-grand-total">
            <td><?php echo e(trans_choice('accounting::lang.total', 1), false); ?></td>
            <td></td>
            <td style="text-align:right"><?php echo e(number_format($data->sum('debit'), 2), false); ?></td>
            <td style="text-align:right"><?php echo e(number_format($data->sum('credit'), 2), false); ?></td>
        </tr>
    </tbody>
</table>
<?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/report/trial_balance_pdf.blade.php ENDPATH**/ ?>