<?php $__env->startSection('title', __('accounting::lang.accounting') . ' ' . __('business.dashboard')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header no-print">
        <h1>
            <?php echo app('translator')->get('accounting::lang.accounting'); ?>
            <small><?php echo app('translator')->get('business.dashboard'); ?></small>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content no-print">

        <div class="row">

            <!-- ./col -->
            <div class="col-lg-4 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-red">
                    <div class="inner">
                        <h4><strong><span class="no_charts_of_account">&nbsp;</span></strong></h4>
                        <p><?php echo e(__('accounting::lang.charts_of_accounts'), false); ?></p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-pie-graph"></i>
                    </div>
                    <a href="<?php echo e(url('accounting/chart_of_account'), false); ?>" class="small-box-footer"><?php echo app('translator')->get('accounting::lang.more_info'); ?> <i
                            class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->

            <div class="col-lg-4 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h4><strong><span class="no_journal_entries">&nbsp;</span></strong></h4>
                        <p><?php echo e(__('accounting::lang.journal_of_entries'), false); ?></p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                    </div>
                    <a href="<?php echo e(url('accounting/journal_entry'), false); ?>" class="small-box-footer"><?php echo app('translator')->get('accounting::lang.more_info'); ?> <i
                            class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <!-- ./col -->


            <!-- /.col -->
            <?php
                $accounting_transactions_index_page = get_accounting_transactions_index();
            ?>
            <?php if(!empty($accounting_transactions_index_page)): ?>
                <div class="col-lg-4 col-xs-6">
                    <div class="small-box bg-green">
                        <div class="inner">
                            <h4><strong><span class="all_transactions">&nbsp;</span></strong></h4>
                            <p><?php echo e(__('accounting::lang.list_of_all_transactions'), false); ?></p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-stats-bars"></i>
                        </div>
                        <a href="<?php echo e(url($accounting_transactions_index_page), false); ?>" class="small-box-footer"><?php echo app('translator')->get('accounting::lang.more_info'); ?><i
                                class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            <?php endif; ?>
            <!-- ./col -->

            
            <!-- ./col -->

            <!-- ./col -->
            
            <!-- ./col -->


            
            <!-- ./col -->


            <!-- /.col -->

            
            <!-- ./col -->

            
            <!-- ./col -->


        </div>

        <div class="row">
            <div class="col-md-12">
                <?php $__env->startComponent('accounting::components.box'); ?>
                    <?php $__env->slot('title'); ?>
                        <?php echo e(trans('lang_v1.balance'), false); ?> <?php echo e(trans('accounting::lang.by'), false); ?>

                        <?php echo e(trans('account.account_type'), false); ?>

                    <?php $__env->endSlot(); ?>

                    <?php $__env->slot('body'); ?>
                        <div class="col-md-6">
                            <table class="table table-striped table-condensed table-hover">
                                <thead>
                                    <tr>
                                        <th>
                                            <?php echo e(trans_choice('accounting::lang.account', 1), false); ?> <?php echo e(trans_choice('accounting::lang.type', 1), false); ?>

                                        </th>
                                        <th>
                                            <?php echo e(trans('accounting::lang.current'), false); ?>

                                            <?php echo e(trans_choice('accounting::lang.balance', 1), false); ?>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $account_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <span><?php echo e(trans_choice('accounting::general.' . $account_type, 1), false); ?></span>
                                            </td>

                                            <td>
                                                <span><?php echo e(currency_code(), false); ?>

                                                        <?php echo e(number_format(abs($chart_of_accounts->where('account_type', $account_type)->sum('current_balance')), 2), false); ?>                                              </span>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <canvas id="balance_summary_chart"></canvas>
                        </div>
                    <?php $__env->endSlot(); ?>
                <?php echo $__env->renderComponent(); ?>
            </div>

        </div>

        <div class="row">
            <div class="col-md-12">
                <?php $__env->startComponent('accounting::components.widget', ['class' => 'box-primary']); ?>
                    <?php echo $expense_chart->container(); ?>

                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <?php $__env->startComponent('accounting::components.widget', ['class' => 'box-primary']); ?>
                    <?php echo $current_financial_year_chart->container(); ?>

                <?php echo $__env->renderComponent(); ?>
            </div>
            <div class="col-md-6">
                <?php $__env->startComponent('accounting::components.widget', ['class' => 'box-primary']); ?>
                    <?php echo $last_30_days_financial_year_chart->container(); ?>

                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>

    </section>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="<?php echo e(Module::asset('accounting:js/accounting.js'), false); ?>"></script>
    <script src="<?php echo e(asset('js/report.js?v=' . $asset_v), false); ?>"></script>
    <?php echo $expense_chart->script(); ?>

    <?php echo $current_financial_year_chart->script(); ?>

    <?php echo $last_30_days_financial_year_chart->script(); ?>

    <script>
        const data = {
            labels: <?php echo $balance_summary_chart->labels; ?>,
            datasets: [{
                label: 'My First Dataset',
                data: <?php echo $balance_summary_chart->values; ?>,
                backgroundColor: [
                    'rgb(255, 99, 132)',
                    'rgb(54, 162, 235)',
                    'rgb(255, 205, 86)',
                    '#00a65a',
                    '#605ca8',
                ],
                hoverOffset: 4
            }],
        };

        const config = {
            type: 'pie',
            data: data,
        };

        const myChart = new Chart(
            document.getElementById('balance_summary_chart'),
            config
        );
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/dashboard/index.blade.php ENDPATH**/ ?>