<!-- Modal -->
<div class="modal fade" id="mapTransactionsModal" tabindex="-1" role="dialog" aria-labelledby="mapTransactionsModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="mapTransactionsModalLabel">
                    <?php echo e(trans_choice('accounting::general.map_to', 1), false); ?>

                    <?php echo e(trans_choice('accounting::general.chart_of_account', 1), false); ?>

                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form action="<?php echo e(url('accounting/transactions/map_to_chart_of_account'), false); ?>" method="post">
                <?php echo csrf_field(); ?>

                <div class="modal-body">
                    <input type="hidden" name="map_type" value="<?php echo e($map_type, false); ?>">

                    <input type="hidden" name="mapping_for" value="<?php echo e($mapping_for, false); ?>">

                    <input type="hidden" id="transaction_id" name="transaction_id">

                    <div class="form-group">
                        <label for="chart_of_account_id" class="control-label"><?php echo e(trans_choice('accounting::general.map_to', 1), false); ?></label>
                        <v-select label="name_with_subtype" :options="chart_of_accounts" :reduce="account => account.id"
                            v-model="chart_of_account_id">
                            <template #search="{attributes, events}">
                                <input autocomplete="off" class="vs__search <?php $__errorArgs = ['chart_of_account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    v-bind="attributes" v-bind:required="!chart_of_account_id" v-on="events" />
                            </template>
                        </v-select>
                        <input type="hidden" name="chart_of_account_id" v-model="chart_of_account_id">
                        <?php $__errorArgs = ['chart_of_account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message, false); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label for="notes"><?php echo e(trans_choice('accounting::lang.note', 1), false); ?></label>
                        <textarea name="notes" id="notes" cols="30" rows="3" class="form-control"></textarea>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>

            </form>

        </div>
    </div>
</div>
<?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/transactions/partials/map_transactions_modal.blade.php ENDPATH**/ ?>