<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('accounting::lang.view', 1), false); ?> <?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(trans_choice('accounting::general.accounting', 1), false); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('subtitle'); ?>
            <?php echo e(trans_choice('accounting::lang.view', 1), false); ?> <?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.view')): ?>
            <div class="row">

                <?php $__env->startComponent('accounting::components.box'); ?>
                    <?php $__env->slot('title'); ?>
                        <?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?> # <?php echo e($data->first()->transaction_number, false); ?>

                    <?php $__env->endSlot(); ?>

                    <?php $__env->slot('header'); ?>
                        <div class="box-tools">
                            <?php if($data->first()->reversed == 0 && $data->first()->reversible == 1): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accounting.journal_entries.reverse')): ?>
                                    <a href="<?php echo e(url('accounting/journal_entry/' . $data->first()->transaction_number . '/reverse'), false); ?>"
                                        class="btn btn-danger confirm">
                                        <i class="fa fa-undo"></i> <?php echo e(trans_choice('accounting::general.reverse', 1), false); ?>

                                    </a>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-danger">
                                    <?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?> <?php echo e(trans_choice('accounting::general.reversed', 1), false); ?>

                                </span>
                            <?php endif; ?>
                        </div>
                    <?php $__env->endSlot(); ?>

                    <?php $__env->slot('body'); ?>
                        <section class="content">
                            <div class="card">
                                <div class="card-header with-border">

                                    <div class="card-tools">

                                    </div>
                                </div>
                                <div class="card-body">
                                    <table class="table">
                                        <tr>
                                            <td><?php echo e(trans_choice('accounting::lang.business_location', 1), false); ?></td>
                                            <td>
                                                <?php if(!empty($data->first()->business_location)): ?>
                                                    <?php echo e($data->first()->business_location->name, false); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e(trans_choice('accounting::lang.transaction', 1), false); ?> <?php echo e(trans_choice('accounting::lang.date', 1), false); ?>

                                            </td>
                                            <td>
                                                <?php echo e($data->first()->date, false); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('accounting::lang.created_by', 1), false); ?></td>
                                            <td>
                                                <?php if(!empty($data->first()->created_by)): ?>
                                                    <?php echo e($data->first()->created_by->first_name, false); ?> <?php echo e($data->first()->created_by->last_name, false); ?>

                                                <?php else: ?>
                                                    <?php echo e(trans_choice('accounting::lang.system', 1), false); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e(trans_choice('accounting::lang.created_on', 1), false); ?></td>
                                            <td>
                                                <?php echo e($data->first()->created_at, false); ?>

                                            </td>
                                        </tr>
                                    </table>
                                    <table class="table table-bordered table-striped" id="data-table">
                                        <thead>
                                            <tr>
                                                <th> <?php echo e(trans_choice('accounting::lang.id', 1), false); ?></th>
                                                <th> <?php echo e(trans_choice('accounting::lang.type', 1), false); ?></th>
                                                <th> <?php echo e(trans_choice('accounting::lang.account', 1), false); ?></th>
                                                <th> <?php echo e(trans_choice('accounting::general.debit', 1), false); ?></th>
                                                <th> <?php echo e(trans_choice('accounting::general.credit', 1), false); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($key->id, false); ?></td>
                                                    <td>
                                                        <?php if(!empty($key->chart_of_account)): ?>
                                                            <?php if($key->chart_of_account->account_type == 'asset'): ?>
                                                                <?php echo e(trans_choice('accounting::general.asset', 1), false); ?>

                                                            <?php elseif($key->chart_of_account->account_type == 'expense'): ?>
                                                                <?php echo e(trans_choice('accounting::general.expense', 1), false); ?>

                                                            <?php elseif($key->chart_of_account->account_type == 'equity'): ?>
                                                                <?php echo e(trans_choice('accounting::general.equity', 1), false); ?>

                                                            <?php elseif($key->chart_of_account->account_type == 'liability'): ?>
                                                                <?php echo e(trans_choice('accounting::general.liability', 1), false); ?>

                                                            <?php elseif($key->chart_of_account->account_type == 'income'): ?>
                                                                <?php echo e(trans_choice('accounting::general.income', 1), false); ?>

                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if(!empty($key->chart_of_account)): ?>
                                                            <?php echo e($key->chart_of_account->name, false); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if(!empty($key->debit)): ?>
                                                            <?php echo e(number_format($key->debit, 2), false); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if(!empty($key->credit)): ?>
                                                            <?php echo e(number_format($key->credit, 2), false); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>

                                    </table>

                                </div>
                                <!-- /.box-body -->
                            </div>
                        </section>
                    <?php $__env->endSlot(); ?>
                <?php echo $__env->renderComponent(); ?>

            </div>
        <?php endif; ?>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script>
        $(document).ready(function() {
            $('#data-table').DataTable();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/journal_entry/show.blade.php ENDPATH**/ ?>