<?php $__env->startSection('title'); ?>
    <?php echo e($page_title, false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('accounting::report.partials.report_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e($page_title, false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">
        <div class="row">
            <?php $__env->startComponent('accounting::components.box'); ?>
                <?php $__env->slot('header'); ?>
                    <div class="box-tools">
                        <?php $__env->startComponent('accounting::components.download_action_button', [
                            'url' => Request::url(),
                            'filters' => http_build_query($filters),
                            'options' => ['pdf'],
                            ]); ?>
                        <?php echo $__env->renderComponent(); ?>
                    </div>

                    <div class="col-md-4">
                        <form action="<?php echo e(Request::url(), false); ?>" id="financial_year_form">
                            <input type="hidden" name="view" value="<?php echo e(Request::get('view'), false); ?>">
                            <div class="form-group">
                                <label for="year"><?php echo e(trans_choice('accounting::general.financial_year', 1), false); ?></label>
                                <input type="text" class="form-control year-datepicker" name="year" id="financial_year" v-model="financial_year">
                            </div>
                        </form>
                    </div>
                <?php $__env->endSlot(); ?>

                <?php $__env->slot('body'); ?>
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs nav-justified">
                            <li class="<?php if(Request::get('view') == 'monthly'): ?> active <?php endif; ?>">
                                <a href="<?php echo e(request()->view != 'monthly' ? $url->monthly : '#', false); ?>" aria-expanded="true">
                                    <i class="fas fa-calendar" aria-hidden="true"></i>
                                    <?php echo e(trans_choice('accounting::lang.monthly', 1), false); ?>

                                </a>
                            </li>
                            <li class="<?php if(Request::get('view') == 'quarterly'): ?> active <?php endif; ?>">
                                <a href="<?php echo e(request()->view != 'quarterly' ? $url->quarterly : '#', false); ?>" aria-expanded="true">
                                    <i class="fas fa-calendar" aria-hidden="true"></i>
                                    <?php echo e(trans_choice('accounting::lang.quarterly', 1), false); ?>

                                </a>
                            </li>
                        </ul>

                        <div class="tab-content">
                            <div class="tab-pane active">

                                

                                <?php switch(Request::get('view')):
                                    case ('monthly'): ?>
                                        <?php echo $__env->make(
                                            'accounting::report.budget.partials.monthly_view'
                                        , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php break; ?>

                                    <?php case ('quarterly'): ?>
                                        <?php echo $__env->make(
                                            'accounting::report.budget.partials.quarterly_view'
                                        , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php break; ?>

                                    <?php default: ?>
                                        <div class="alert alert-info">
                                            <?php echo e(trans('accounting::lang.an_error_occurred'), false); ?>

                                        </div>
                                <?php endswitch; ?>

                            </div>
                        </div>
                    </div>
                <?php $__env->endSlot(); ?>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <?php echo $__env->make('accounting::report.partials.report_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $(function() {
            $('#financial_year').on('change', function() {
                document.getElementById('financial_year_form').submit();
            })
        });

        new Vue({
            el: '#vue-app',
            data() {
                return {
                    financial_year_start: "<?php echo e($financial_year_start, false); ?>",
                    financial_year: "<?php echo e($financial_year, false); ?>",
                    business_id: "<?php echo e(session('business.id'), false); ?>",
                    view: "<?php echo e(Request::get('view'), false); ?>",
                }
            },
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/report/budget/budget_overview.blade.php ENDPATH**/ ?>