<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('accounting::lang.reconcile', 1), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(trans_choice('accounting::lang.reconcile', 1), false); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('subtitle'); ?>
            <?php echo e(trans('accounting::lang.reconcile_subtitle'), false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">

        <div class="row">

            <?php $__env->startComponent('accounting::components.box'); ?>
                <?php $__env->slot('body'); ?>
                    <section class="content">
                        <?php echo $__env->make('accounting::reconcile.partials.reconcile_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('accounting::reconcile.partials.undo_reconcile_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </section>
                <?php $__env->endSlot(); ?>
            <?php echo $__env->renderComponent(); ?>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        const app = new Vue({
            el: '#vue-app',
            data: {
                ending_balance: "<?php echo e(old('ending_balance'), false); ?>",
                ending_date: "<?php echo e(old('ending_date'), false); ?>",
                chart_of_accounts: <?php echo json_encode($chart_of_accounts); ?>,
                chart_of_account_id: parseInt("<?php echo e(old('chart_of_account_id'), false); ?>"),
            },

            computed: {
                chart_of_account() {
                    return !isNaN(this.chart_of_account_id) ?
                        this.chart_of_accounts.find(account => account.id == this.chart_of_account_id) : {};
                }
            },

            methods: {
                storeUndoReconciliation() {
                    const form = document.getElementById('undo_last_reconcile_form');

                    swal({
                            title: `Undo last reconcilation for ${this.chart_of_account.name}?`,
                            text: 'This action may not be reversible',
                            icon: "warning",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((clickedOk) => {
                            if (clickedOk) {
                                form.submit();
                            }
                        });
                }
            }
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/reconcile/index.blade.php ENDPATH**/ ?>