<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('accounting::report.accounts_receivable_ageing_summary', 1), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('accounting::report.partials.report_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(trans_choice('accounting::general.accounting', 1), false); ?> <?php echo e(trans_choice('accounting::lang.report', 2), false); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('subtitle'); ?>
            <?php echo e(trans_choice('accounting::report.accounts_receivable_ageing_summary', 1), false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">
        <div class="row">

            <?php $__env->startComponent('accounting::components.box'); ?>
                <?php $__env->slot('header'); ?>
                    <div class="box-tools">
                        <?php $__env->startComponent('accounting::components.download_action_button', [
                            'url' => Request::url(),
                            'filters' => http_build_query($_GET),
                            ]); ?>
                        <?php echo $__env->renderComponent(); ?>
                    </div>
                <?php $__env->endSlot(); ?>

                <?php $__env->slot('body'); ?>
                    <section class="content">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <?php echo e(trans_choice('accounting::report.accounts_receivable_ageing_summary', 1), false); ?>

                                    <?php if(!empty($start_date)): ?>
                                        <?php echo e(trans('accounting::lang.for_period'), false); ?>: <b><?php echo e(readable_date($start_date), false); ?>

                                            <?php echo e(trans('accounting::lang.to'), false); ?>

                                            <?php echo e(readable_date($end_date), false); ?></b>
                                    <?php endif; ?>
                                </h4>
                            </div>
                            <div class="card-body">
                                <form method="get" action="<?php echo e(Request::url(), false); ?>" class="___class_+?23___">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label"
                                                    for="location_id"><?php echo e(trans_choice('accounting::lang.business_location', 1), false); ?></label>
                                                <select class="form-control select2" name="location_id" id="location_id" required>
                                                    <option value="" disabled selected><?php echo e(trans_choice('accounting::lang.select', 1), false); ?></option>
                                                    <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key->id, false); ?>" <?php if($location_id == $key->id): ?> selected <?php endif; ?>>
                                                            <?php echo e($key->name, false); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label"
                                                    for="start_date"><?php echo e(trans_choice('accounting::lang.start_date', 1), false); ?></label>
                                                <input type="text" value="<?php echo e($start_date, false); ?>"
                                                    class="form-control datepicker <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="start_date"
                                                    id="start_date" required>

                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label"
                                                    for="end_date"><?php echo e(trans_choice('accounting::lang.end_date', 1), false); ?></label>
                                                <input type="text" value="<?php echo e($end_date, false); ?>"
                                                    class="form-control datepicker <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="end_date"
                                                    id="end_date" required>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-2 float-right filter-btn-row">
                                            <span class="input-group-btn">
                                                <button type="submit" class="btn bg-olive btn-flat"><?php echo e(trans_choice('accounting::lang.submit', 1), false); ?>

                                                </button>
                                            </span>
                                            <span class="input-group-btn">
                                                <a href="<?php echo e(Request::url(), false); ?>"
                                                    class="btn btn-danger btn-flat pull-right"><?php echo e(trans_choice('accounting::lang.clear', 1), false); ?>!</a>
                                            </span>
                                        </div>
                                    </div>
                                </form>

                            </div>
                            <!-- /.box-body -->

                        </div>

                    </section>
                <?php $__env->endSlot(); ?>
            <?php echo $__env->renderComponent(); ?>

            <?php $__env->startComponent('accounting::components.box'); ?>
                <?php $__env->slot('body'); ?>
                    <h3 class="text-center"><?php echo e(trans_choice('accounting::report.accounts_receivable_ageing_summary', 1), false); ?></h3>
                    <?php $__env->startComponent('accounting::components.tree_view_table'); ?>
                        <thead>
                            <th><?php echo e(trans_choice('accounting::lang.account', 1), false); ?></th>
                            <th style="text-align: right"><?php echo e(trans('accounting::lang.current'), false); ?></th>
                            <th style="text-align: right"><?php echo e(trans('accounting::general.one_to_thirty'), false); ?></th>
                            <th style="text-align: right"><?php echo e(trans('accounting::general.thirty_one_to_sixty'), false); ?></th>
                            <th style="text-align: right"><?php echo e(trans('accounting::general.sixty_one_to_ninety'), false); ?></th>
                            <th style="text-align: right"><?php echo e(trans('accounting::general.ninety_one_and_over'), false); ?></th>
                            <th style="text-align: right"><?php echo e(trans_choice('accounting::lang.amount', 1), false); ?></th>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $chart_of_accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart_of_account_name => $chart_of_account_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $chart_of_account = $data->where('chart_of_account_id', $chart_of_account_id);
                                ?>
                                <tr>
                                    <td><?php echo e($chart_of_account_name, false); ?></td>
                                    <td style="text-align: right">
                                        <?php echo e($chart_of_account->where('transaction_date', $days_past->today)->sum('amount_due'), false); ?></td>
                                    <td style="text-align: right">
                                        <?php echo e($chart_of_account->whereBetween('transaction_date', [$days_past->thirty_days_ago, $days_past->yesterday])->sum('amount_due'), false); ?>

                                    </td>
                                    <td style="text-align: right">
                                        <?php echo e($chart_of_account->whereBetween('transaction_date', [$days_past->sixty_days_ago, $days_past->thirty_one_days_ago])->sum('amount_due'), false); ?>

                                    </td>
                                    <td style="text-align: right">
                                        <?php echo e($chart_of_account->whereBetween('transaction_date', [$days_past->ninety_days_ago, $days_past->sixty_one_days_ago])->sum('amount_due'), false); ?>

                                    </td>
                                    <td style="text-align: right">
                                        <?php echo e($chart_of_account->where('transaction_date', '<=', $days_past->ninety_one_days_ago)->sum('amount_due'), false); ?>

                                    </td>
                                    <td style="text-align: right; font-weight: bold"><?php echo e($chart_of_account->sum('amount_due'), false); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr class="bg-grand-total" style="font-weight: bold">
                                <td><?php echo e(trans('accounting::lang.total'), false); ?></td>
                                <td style="text-align: right"><?php echo e($data->where('transaction_date', $days_past->today)->sum('amount_due'), false); ?></td>
                                <td style="text-align: right">
                                    <?php echo e($data->whereBetween('transaction_date', [$days_past->thirty_days_ago, $days_past->yesterday])->sum('amount_due'), false); ?>

                                </td>
                                <td style="text-align: right">
                                    <?php echo e($data->whereBetween('transaction_date', [$days_past->sixty_days_ago, $days_past->thirty_one_days_ago])->sum('amount_due'), false); ?>

                                </td>
                                <td style="text-align: right">
                                    <?php echo e($data->whereBetween('transaction_date', [$days_past->ninety_days_ago, $days_past->sixty_one_days_ago])->sum('amount_due'), false); ?>

                                </td>
                                <td style="text-align: right">
                                    <?php echo e($data->where('transaction_date', '<=', $days_past->ninety_one_days_ago)->sum('amount_due'), false); ?></td>
                                <td style="text-align: right"><?php echo e($data->sum('amount_due'), false); ?></td>
                            </tr>
                        </tbody>
                    <?php echo $__env->renderComponent(); ?>
                <?php $__env->endSlot(); ?>
            <?php echo $__env->renderComponent(); ?>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <?php echo $__env->make('accounting::report.partials.report_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/report/accounts_receivable_ageing_summary.blade.php ENDPATH**/ ?>