<!-- Modal -->
<div class="modal fade" id="editMonthlyModal" tabindex="-1" role="dialog" aria-labelledby="editMonthlyModalTitle" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editMonthlyModalTitle">
                    {{ chart_of_account.name }} - <?php echo e(ucfirst(Request::get('view')), false); ?>

                    <?php echo e(trans_choice('accounting::general.budget', 1), false); ?> <?php echo e($financial_year, false); ?>

                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form action="<?php echo e(url('accounting/budget/update_monthly_budget'), false); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <input type="hidden" name="business_id" v-model="business_id">

                    <input type="hidden" name="chart_of_account_id" v-model="chart_of_account_id">

                    <input type="hidden" name="financial_year" v-model="financial_year">

                    <?php for($i = 0; $i < 12; $i++): ?>
                        <?php
                            $month_number = $i + 1;
                            $id = 'month_' . $month_number; // Added the first month January starts at 1 but array indexes are zero based (start at zero)
                        ?>

                        <div class="form-group">
                            <label for="<?php echo e($id, false); ?>"><?php echo e($months[$i], false); ?></label>
                            <input class="form-control" id="<?php echo e($id, false); ?>" name="<?php echo e($id, false); ?>"
                                v-model="months[<?php echo e($month_number, false); ?>]">
                            <small>
                                <a href="#" input_id="<?php echo e($id, false); ?>" class="apply_for_all">
                                    <?php echo e(trans('accounting::general.apply_for_all'), false); ?>

                                    <?php echo e(trans_choice('accounting::lang.month', 2), false); ?>

                                </a>
                            </small>
                        </div>
                    <?php endfor; ?>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>

            </form>

        </div>
    </div>
</div>
<?php /**PATH /home/lekkjajw/public_html/lekkipremiumwater/Modules/Accounting/Providers/../Resources/views/budget/modals/edit_monthly_modal.blade.php ENDPATH**/ ?>